/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.search;

import java.util.PriorityQueue;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.control.SourceUnit;

public class LexicalClassVisitor {
    private final ModuleNode module;
    private PriorityQueue<ComparableNode> nodeList;

    public LexicalClassVisitor(ModuleNode module) {
        this.module = module;
    }

    public ASTNode getNextNode() {
        if (!this.hasNextNode()) {
            return null;
        }
        return ((ComparableNode)this.nodeList.remove()).thisNode;
    }

    private void initialize() {
        this.nodeList = new PriorityQueue();
        LexicalPrevisitor visitor = new LexicalPrevisitor();
        visitor.doVisit(this.module);
    }

    public boolean hasNextNode() {
        if (this.nodeList == null) {
            this.initialize();
        }
        return !this.nodeList.isEmpty();
    }

    public void reset() {
        this.nodeList = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComparableNode
    implements Comparable<ComparableNode> {
        final ASTNode thisNode;

        ComparableNode(ASTNode thisNode) {
            this.thisNode = thisNode;
        }

        @Override
        public int compareTo(ComparableNode o) {
            if (this.thisNode.getStart() != o.thisNode.getStart()) {
                return this.thisNode.getStart() - o.thisNode.getStart();
            }
            return o.thisNode.getEnd() - this.thisNode.getEnd();
        }
    }

    private class LexicalPrevisitor
    extends ClassCodeVisitorSupport {
        private LexicalPrevisitor() {
        }

        public void visitClass(ClassNode node) {
            this.maybeAddNode(node);
            this.visitObjectInitializerStatements(node);
            node.visitContents(this);
        }

        private void maybeAddNode(ASTNode node) {
            if (node.getEnd() > 0) {
                LexicalClassVisitor.this.nodeList.add(new ComparableNode(node));
            }
        }

        protected void visitObjectInitializerStatements(ClassNode node) {
            this.maybeAddNode(node);
            super.visitObjectInitializerStatements(node);
        }

        public void visitVariableExpression(VariableExpression node) {
            this.maybeAddNode(node);
            super.visitVariableExpression(node);
        }

        public void visitConstructor(ConstructorNode node) {
            this.maybeAddNode(node);
            super.visitConstructor(node);
        }

        public void visitMethod(MethodNode node) {
            this.maybeAddNode(node);
            super.visitMethod(node);
        }

        public void visitField(FieldNode node) {
            super.visitField(node);
        }

        protected SourceUnit getSourceUnit() {
            return null;
        }

        public void visitAssertStatement(AssertStatement node) {
            this.maybeAddNode(node);
            super.visitAssertStatement(node);
        }

        public void visitBlockStatement(BlockStatement node) {
            this.maybeAddNode(node);
            super.visitBlockStatement(node);
        }

        public void visitBreakStatement(BreakStatement node) {
            this.maybeAddNode(node);
            super.visitBreakStatement(node);
        }

        public void visitCaseStatement(CaseStatement node) {
            this.maybeAddNode(node);
            super.visitCaseStatement(node);
        }

        public void visitCatchStatement(CatchStatement node) {
            this.maybeAddNode(node);
            super.visitCatchStatement(node);
        }

        public void visitContinueStatement(ContinueStatement node) {
            this.maybeAddNode(node);
            super.visitContinueStatement(node);
        }

        public void visitDoWhileLoop(DoWhileStatement node) {
            this.maybeAddNode(node);
            super.visitDoWhileLoop(node);
        }

        public void visitExpressionStatement(ExpressionStatement node) {
            this.maybeAddNode(node);
            super.visitExpressionStatement(node);
        }

        public void visitForLoop(ForStatement node) {
            this.maybeAddNode(node);
            super.visitForLoop(node);
        }

        public void visitIfElse(IfStatement node) {
            this.maybeAddNode(node);
            super.visitIfElse(node);
        }

        public void visitReturnStatement(ReturnStatement node) {
            this.maybeAddNode(node);
            super.visitReturnStatement(node);
        }

        public void visitSwitch(SwitchStatement node) {
            this.maybeAddNode(node);
            super.visitSwitch(node);
        }

        public void visitSynchronizedStatement(SynchronizedStatement node) {
            this.maybeAddNode(node);
            super.visitSynchronizedStatement(node);
        }

        public void visitThrowStatement(ThrowStatement node) {
            this.maybeAddNode(node);
            super.visitThrowStatement(node);
        }

        public void visitTryCatchFinally(TryCatchStatement node) {
            this.maybeAddNode(node);
            super.visitTryCatchFinally(node);
        }

        public void visitWhileLoop(WhileStatement node) {
            this.maybeAddNode(node);
            super.visitWhileLoop(node);
        }

        protected void visitEmptyStatement(EmptyStatement node) {
            this.maybeAddNode(node);
            super.visitEmptyStatement(node);
        }

        public void visitMethodCallExpression(MethodCallExpression node) {
            this.maybeAddNode(node);
            super.visitMethodCallExpression(node);
        }

        public void visitStaticMethodCallExpression(StaticMethodCallExpression node) {
            this.maybeAddNode(node);
            super.visitStaticMethodCallExpression(node);
        }

        public void visitConstructorCallExpression(ConstructorCallExpression node) {
            this.maybeAddNode(node);
            super.visitConstructorCallExpression(node);
        }

        public void visitBinaryExpression(BinaryExpression node) {
            this.maybeAddNode(node);
            super.visitBinaryExpression(node);
        }

        public void visitTernaryExpression(TernaryExpression node) {
            this.maybeAddNode(node);
            super.visitTernaryExpression(node);
        }

        public void visitShortTernaryExpression(ElvisOperatorExpression node) {
            this.maybeAddNode(node);
            super.visitShortTernaryExpression(node);
        }

        public void visitPostfixExpression(PostfixExpression node) {
            this.maybeAddNode(node);
            super.visitPostfixExpression(node);
        }

        public void visitPrefixExpression(PrefixExpression node) {
            this.maybeAddNode(node);
            super.visitPrefixExpression(node);
        }

        public void visitBooleanExpression(BooleanExpression node) {
            this.maybeAddNode(node);
            super.visitBooleanExpression(node);
        }

        public void visitNotExpression(NotExpression node) {
            this.maybeAddNode(node);
            super.visitNotExpression(node);
        }

        public void visitClosureExpression(ClosureExpression node) {
            this.maybeAddNode(node);
            super.visitClosureExpression(node);
        }

        public void visitTupleExpression(TupleExpression node) {
            this.maybeAddNode(node);
            super.visitTupleExpression(node);
        }

        public void visitListExpression(ListExpression node) {
            this.maybeAddNode(node);
            super.visitListExpression(node);
        }

        public void visitArrayExpression(ArrayExpression node) {
            this.maybeAddNode(node);
            super.visitArrayExpression(node);
        }

        public void visitMapExpression(MapExpression node) {
            this.maybeAddNode(node);
            super.visitMapExpression(node);
        }

        public void visitMapEntryExpression(MapEntryExpression node) {
            this.maybeAddNode(node);
            super.visitMapEntryExpression(node);
        }

        public void visitRangeExpression(RangeExpression node) {
            this.maybeAddNode(node);
            super.visitRangeExpression(node);
        }

        public void visitSpreadExpression(SpreadExpression node) {
            this.maybeAddNode(node);
            super.visitSpreadExpression(node);
        }

        public void visitSpreadMapExpression(SpreadMapExpression node) {
            this.maybeAddNode(node);
            super.visitSpreadMapExpression(node);
        }

        public void visitMethodPointerExpression(MethodPointerExpression node) {
            this.maybeAddNode(node);
            super.visitMethodPointerExpression(node);
        }

        public void visitUnaryMinusExpression(UnaryMinusExpression node) {
            this.maybeAddNode(node);
            super.visitUnaryMinusExpression(node);
        }

        public void visitUnaryPlusExpression(UnaryPlusExpression node) {
            this.maybeAddNode(node);
            super.visitUnaryPlusExpression(node);
        }

        public void visitBitwiseNegationExpression(BitwiseNegationExpression node) {
            this.maybeAddNode(node);
            super.visitBitwiseNegationExpression(node);
        }

        public void visitCastExpression(CastExpression node) {
            this.maybeAddNode(node);
            super.visitCastExpression(node);
        }

        public void visitConstantExpression(ConstantExpression node) {
            this.maybeAddNode(node);
            super.visitConstantExpression(node);
        }

        public void visitClassExpression(ClassExpression node) {
            this.maybeAddNode(node);
            super.visitClassExpression(node);
        }

        public void visitDeclarationExpression(DeclarationExpression node) {
            this.maybeAddNode(node);
            super.visitDeclarationExpression(node);
        }

        public void visitPropertyExpression(PropertyExpression node) {
            this.maybeAddNode(node);
            super.visitPropertyExpression(node);
        }

        public void visitAttributeExpression(AttributeExpression node) {
            this.maybeAddNode(node);
            super.visitAttributeExpression(node);
        }

        public void visitFieldExpression(FieldExpression node) {
            this.maybeAddNode(node);
            super.visitFieldExpression(node);
        }

        public void visitGStringExpression(GStringExpression node) {
            this.maybeAddNode(node);
            super.visitGStringExpression(node);
        }

        public void visitArgumentlistExpression(ArgumentListExpression node) {
            this.maybeAddNode(node);
            super.visitArgumentlistExpression(node);
        }

        public void visitClosureListExpression(ClosureListExpression node) {
            this.maybeAddNode(node);
            super.visitClosureListExpression(node);
        }

        public void visitBytecodeExpression(BytecodeExpression node) {
            this.maybeAddNode(node);
            super.visitBytecodeExpression(node);
        }

        void doVisit(ModuleNode module) {
            for (ClassNode node : module.getClasses()) {
                this.visitClass(node);
            }
        }
    }
}

