/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class GroovyCoreActivator {
    public static final String PLUGIN_ID = "com.diffplug.gradle.spotless.groovy.eclipse";
    private static GroovyCoreActivator INSTANCE = null;
    private final ILog logger;
    private final Bundle bundle = new MockOsgiBundle();

    public GroovyCoreActivator() {
        this.logger = new LogAdapter(this.bundle);
        GroovyLogManager.manager.setUseDefaultLogger(false);
    }

    public static GroovyCoreActivator getDefault() {
        if (null == INSTANCE) {
            INSTANCE = new GroovyCoreActivator();
        }
        return INSTANCE;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public ILog getLog() {
        return this.logger;
    }

    private static class MockOsgiBundle
    implements Bundle {
        private MockOsgiBundle() {
        }

        @Override
        public int compareTo(Bundle arg0) {
            return 0;
        }

        @Override
        public <A> A adapt(Class<A> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<URL> findEntries(String arg0, String arg1, boolean arg2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BundleContext getBundleContext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getBundleId() {
            return 0L;
        }

        @Override
        public File getDataFile(String arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public URL getEntry(String arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<String> getEntryPaths(String arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Dictionary<String, String> getHeaders() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Dictionary<String, String> getHeaders(String arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public String getLocation() {
            return GroovyCoreActivator.PLUGIN_ID;
        }

        @Override
        public ServiceReference<?>[] getRegisteredServices() {
            return new ServiceReference[0];
        }

        @Override
        public URL getResource(String arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<URL> getResources(String arg0) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceReference<?>[] getServicesInUse() {
            return new ServiceReference[0];
        }

        @Override
        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int arg0) {
            return new HashMap<X509Certificate, List<X509Certificate>>();
        }

        @Override
        public int getState() {
            return 32;
        }

        @Override
        public String getSymbolicName() {
            return GroovyCoreActivator.PLUGIN_ID;
        }

        @Override
        public Version getVersion() {
            return new Version(0, 0, 0);
        }

        @Override
        public boolean hasPermission(Object arg0) {
            return true;
        }

        @Override
        public Class<?> loadClass(String arg0) throws ClassNotFoundException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void start() throws BundleException {
        }

        @Override
        public void start(int arg0) throws BundleException {
        }

        @Override
        public void stop() throws BundleException {
        }

        @Override
        public void stop(int arg0) throws BundleException {
        }

        @Override
        public void uninstall() throws BundleException {
        }

        @Override
        public void update() throws BundleException {
        }

        @Override
        public void update(InputStream arg0) throws BundleException {
        }
    }

    private static class LogAdapter
    implements ILog {
        private static final Integer[] QUIET_SEVERITY_VALUES = new Integer[]{8, 1, 0};
        private static final Set<Integer> QUIET_SEVERITIES = new HashSet<Integer>(Arrays.asList(QUIET_SEVERITY_VALUES));
        private final Set<ILogListener> listeners = new HashSet<ILogListener>();
        private final Bundle bundle;

        public LogAdapter(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public void addLogListener(ILogListener arg0) {
            this.listeners.add(arg0);
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }

        @Override
        public void log(IStatus status) {
            for (ILogListener listener : this.listeners) {
                listener.logging(status, GroovyCoreActivator.PLUGIN_ID);
            }
            if (QUIET_SEVERITIES.contains(status.getSeverity())) {
                System.out.println(status.getMessage());
            } else {
                System.err.println(status.getMessage());
            }
        }

        @Override
        public void removeLogListener(ILogListener arg0) {
            this.listeners.remove(arg0);
        }
    }
}

