/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core;

import org.codehaus.groovy.eclipse.core.GroovyCoreActivator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class GroovyCore {
    static boolean trace;

    static {
        String value = Platform.getDebugOption("org.codehaus.groovy.eclipse.core/trace");
        if (value != null && value.equalsIgnoreCase("true")) {
            trace = true;
        }
    }

    public static void logException(String message, Throwable throwable) {
        GroovyCore.log(4, message, throwable);
    }

    public static void logWarning(String message) {
        GroovyCore.log(2, message, null);
    }

    public static void logWarning(String message, Throwable t) {
        GroovyCore.log(2, message, t);
    }

    public static void logTraceMessage(String message) {
        GroovyCore.log(1, message, null);
    }

    private static void log(int severity, String message, Throwable throwable) {
        Status status = new Status(severity, GroovyCoreActivator.getDefault().getBundle().getSymbolicName(), 0, message, throwable);
        GroovyCoreActivator.getDefault().getLog().log(status);
    }

    public static void trace(String message) {
        if (trace) {
            GroovyCore.logTraceMessage("trace: " + message);
        }
    }

    public static void errorRunningGroovyFile(IFile file, Exception exception) {
        GroovyCore.logException("Error running Groovy file: " + file.getName(), exception);
    }

    public static void errorRunningGroovy(Exception exception) {
        GroovyCore.logException("Error running Groovy", exception);
    }
}

