/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr;

import groovyjarjarantlr.RecognitionException;
import groovyjarjarantlr.TokenStreamException;
import groovyjarjarantlr.TokenStreamIOException;
import groovyjarjarantlr.TokenStreamRecognitionException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.antlr.AntlrParserPlugin;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.ICSTReporter;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.UnicodeEscapingReader;
import org.codehaus.groovy.antlr.UnicodeLexerSharedInputState;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.antlr.parser.GroovyRecognizer;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;

public class ErrorRecoveredCSTParserPlugin
extends AntlrParserPlugin {
    private final ICSTReporter reporter;

    ErrorRecoveredCSTParserPlugin(ICSTReporter reporter) {
        this.reporter = reporter;
    }

    public void transformCSTIntoAST(SourceUnit sourceUnit, Reader reader, SourceBuffer sourceBuffer) throws CompilationFailedException {
        GroovyRecognizer parser;
        block8: {
            this.ast = null;
            this.setController(sourceUnit);
            UnicodeEscapingReader unicodeReader = new UnicodeEscapingReader(reader, sourceBuffer);
            GroovyLexer lexer = new GroovyLexer(new UnicodeLexerSharedInputState(unicodeReader));
            unicodeReader.setLexer(lexer);
            parser = GroovyRecognizer.make(lexer);
            parser.setSourceBuffer(sourceBuffer);
            this.tokenNames = parser.getTokenNames();
            parser.setFilename(sourceUnit.getName());
            try {
                parser.compilationUnit();
                this.configureLocationSupport(sourceBuffer);
            }
            catch (TokenStreamRecognitionException tsre) {
                this.configureLocationSupport(sourceBuffer);
                RecognitionException e = tsre.recog;
                SyntaxException se = new SyntaxException(e.getMessage(), (Throwable)e, e.getLine(), e.getColumn());
                se.setFatal(true);
                sourceUnit.addError(se);
            }
            catch (RecognitionException e) {
                this.configureLocationSupport(sourceBuffer);
                int origLine = e.getLine();
                int origColumn = e.getColumn();
                int[] newInts = this.fixLineColumn(origLine, origColumn);
                int newLine = newInts[0];
                int newColumn = newInts[1];
                SyntaxException se = new SyntaxException(e.getMessage(), (Throwable)e, newLine, newColumn);
                se.setFatal(true);
                sourceUnit.addError(se);
            }
            catch (TokenStreamException e) {
                this.configureLocationSupport(sourceBuffer);
                boolean handled = false;
                if (e instanceof TokenStreamIOException) {
                    TokenStreamIOException cfr_ignored_0 = (TokenStreamIOException)e;
                    String m = e.getMessage();
                    if (m != null && m.startsWith("Did not find four digit hex character code.")) {
                        try {
                            int linepos = m.indexOf("line:");
                            int colpos = m.indexOf("col:");
                            int line = Integer.valueOf(m.substring(linepos + 5, colpos).trim());
                            int col = Integer.valueOf(m.substring(colpos + 4).trim());
                            SyntaxException se = new SyntaxException(e.getMessage(), (Throwable)e, line, col);
                            se.setFatal(true);
                            sourceUnit.addError(se);
                            handled = true;
                        }
                        catch (Throwable t) {
                            System.err.println(m);
                            t.printStackTrace(System.err);
                        }
                    }
                }
                if (handled) break block8;
                sourceUnit.addException(e);
            }
        }
        this.ast = parser.getAST();
        sourceUnit.setComments(parser.getComments());
        this.reportCST(sourceUnit, parser);
    }

    private void reportCST(SourceUnit sourceUnit, GroovyRecognizer parser) {
        List errorList = parser.getErrorList();
        GroovySourceAST cst = (GroovySourceAST)parser.getAST();
        if (this.reporter != null) {
            if (cst != null) {
                this.reporter.generatedCST(sourceUnit.getName(), cst);
            }
            if (errorList.size() != 0) {
                this.reporter.reportErrors(sourceUnit.getName(), Collections.unmodifiableList(errorList));
            }
        } else {
            for (Map error : errorList) {
                int origLine = (Integer)error.get("line");
                int origColumn = (Integer)error.get("column");
                int[] newInts = this.fixLineColumn(origLine, origColumn);
                int newLine = newInts[0];
                int newColumn = newInts[1];
                SyntaxException se = new SyntaxException((String)error.get("error"), newLine, newColumn);
                sourceUnit.addError(se);
            }
        }
    }

    private int[] fixLineColumn(int origLine, int origColumn) {
        int offset;
        if (this.locations.isPopulated() && (offset = this.locations.findOffset(origLine, origColumn)) >= this.locations.getEnd() - 1) {
            return this.locations.getRowCol(this.locations.getEnd() - 1);
        }
        return new int[]{origLine, origColumn};
    }
}

