/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless.groovy.eclipse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.codehaus.groovy.eclipse.core.GroovyCoreActivator;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferencesOnStore;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyFormatter;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.text.edits.TextEdit;

public class GrEclipseFormatterStepImpl {
    private final FormatterPreferencesOnStore preferencesStore;

    public GrEclipseFormatterStepImpl(Properties properties) throws Exception {
        PreferenceStore preferences = GrEclipseFormatterStepImpl.createPreferences(properties);
        this.preferencesStore = new FormatterPreferencesOnStore(preferences);
    }

    public String format(String raw) throws Exception {
        Document doc = new Document(raw);
        GroovyErrorListener errorListener = new GroovyErrorListener();
        TextSelection selectAll = new TextSelection(doc, 0, doc.getLength());
        DefaultGroovyFormatter codeFormatter = new DefaultGroovyFormatter(selectAll, doc, this.preferencesStore, false);
        TextEdit edit = ((GroovyFormatter)codeFormatter).format();
        if (errorListener.errorsDetected()) {
            throw new IllegalArgumentException(errorListener.toString());
        }
        edit.apply(doc);
        return doc.get();
    }

    private static PreferenceStore createPreferences(Properties properties) throws IOException {
        PreferenceStore preferences = new PreferenceStore();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        properties.store(output, null);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        preferences.load(input);
        return preferences;
    }

    private static class GroovyErrorListener
    implements ILogListener {
        private final List<String> errors = new LinkedList<String>();

        public GroovyErrorListener() {
            ILog groovyLogger = GroovyCoreActivator.getDefault().getLog();
            groovyLogger.addLogListener(this);
        }

        @Override
        public void logging(IStatus status, String plugin) {
            if (!status.isOK()) {
                this.errors.add(status.getMessage());
            }
        }

        public boolean errorsDetected() {
            ILog groovyLogger = GroovyCoreActivator.getDefault().getLog();
            groovyLogger.removeLogListener(this);
            return 0 != this.errors.size();
        }

        public String toString() {
            StringBuilder string = new StringBuilder();
            if (1 < this.errors.size()) {
                string.append("Multiple problems detected during step execution:");
            } else if (0 == this.errors.size()) {
                string.append("Step sucesfully executed.");
            }
            for (String error : this.errors) {
                string.append(System.lineSeparator());
                string.append(error);
            }
            return string.toString();
        }
    }
}

