/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.compiler;

import java.util.Hashtable;
import java.util.Iterator;
import org.codehaus.groovy.antlr.AntlrParserPlugin;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.ParserPlugin;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class GroovySnippetParser {
    private CategorizedProblem[] problems;

    public CategorizedProblem[] getProblems() {
        return this.problems;
    }

    public ModuleNode parse(CharSequence source) {
        ModuleNode node = this.dietParse(source).getModuleNode();
        if (node == null) {
            return null;
        }
        for (ClassNode classNode : node.getClasses()) {
            Iterator<MethodNode> it = classNode.getMethods().iterator();
            while (it.hasNext()) {
                MethodNode method = it.next();
                if (!GroovyUtils.isSynthetic(method)) continue;
                it.remove();
            }
        }
        return node;
    }

    public GroovySourceAST parseForCST(CharSequence source) {
        SourceUnit sourceUnit = this.dietParse(source).getSourceUnit();
        ParserPlugin parserPlugin = (ParserPlugin)ReflectionUtils.getPrivateField(SourceUnit.class, "parserPlugin", sourceUnit);
        if (parserPlugin instanceof AntlrParserPlugin) {
            return (GroovySourceAST)ReflectionUtils.getPrivateField(AntlrParserPlugin.class, "ast", parserPlugin);
        }
        return null;
    }

    private GroovyCompilationUnitDeclaration dietParse(CharSequence source) {
        Hashtable<String, String> options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "enabled");
        CompilerOptions compilerOptions = new CompilerOptions(options);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory());
        GroovyParser parser = new GroovyParser(compilerOptions, problemReporter, false, true);
        MockCompilationUnit unit = new MockCompilationUnit(source.toString().toCharArray(), "Snippet.groovy".toCharArray());
        CompilationResult compilationResult = new CompilationResult(unit, 0, 0, compilerOptions.maxProblemsPerUnit);
        GroovyCompilationUnitDeclaration gcud = parser.dietParse(unit, compilationResult);
        this.problems = compilationResult.getProblems();
        return gcud;
    }

    private static class MockCompilationUnit
    implements ICompilationUnit {
        private char[] contents;
        private char[] fileName;

        MockCompilationUnit(char[] contents, char[] fileName) {
            this.contents = contents;
            this.fileName = fileName;
        }

        @Override
        public char[] getContents() {
            return this.contents;
        }

        @Override
        public char[] getFileName() {
            return this.fileName;
        }

        @Override
        public char[] getMainTypeName() {
            return CharOperation.NO_CHAR;
        }

        @Override
        public char[][] getPackageName() {
            return CharOperation.NO_CHAR_CHAR;
        }

        @Override
        public boolean ignoreOptionalProblems() {
            return false;
        }
    }
}

