/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect;

import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MoreCollectors {
    public static <T> Collector<T, ?, Optional<T>> singleOrEmpty() {
        return Collectors.collectingAndThen(Collectors.toList(), lst -> lst.size() == 1 ? Optional.of(lst.get(0)) : Optional.empty());
    }

    public static <T> Optional<T> singleOrEmptyShortCircuiting(Stream<T> stream) {
        return stream.limit(2L).map(Optional::ofNullable).reduce(Optional.empty(), (a, b) -> a.isPresent() ^ b.isPresent() ? b : Optional.empty());
    }

    public static String codePointsToString(IntStream codePoints) {
        return codePoints.collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

