/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.base.Preconditions;

@GwtCompatible
final class CollectPreconditions {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("null key in entry: null=" + value);
        }
        if (value == null) {
            throw new NullPointerException("null value in entry: " + key + "=null");
        }
    }

    static int checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    static void checkPositive(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException(name + " must be positive but was: " + value);
        }
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState((boolean)canRemove, (Object)"no calls to next() since the last call to remove()");
    }
}

