/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.oaid;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.appsflyer.oaid.OaidClient;
import com.bun.miitmdid.core.MdidSdkHelper;
import com.bun.miitmdid.interfaces.IIdentifierListener;
import com.bun.miitmdid.interfaces.IdSupplier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

class OaidMsaClient {
    OaidMsaClient() {
    }

    @Nullable
    static OaidClient.Info fetchMsa(Context context, final Logger logger, long timeout, TimeUnit unit) {
        try {
            String oaid;
            final LinkedBlockingQueue oaidHolder = new LinkedBlockingQueue();
            int result = MdidSdkHelper.InitSdk((Context)context, (logger.getLevel() == null ? 1 : 0) != 0, (IIdentifierListener)new IIdentifierListener(){

                public void OnSupport(boolean support, IdSupplier supplier) {
                    try {
                        oaidHolder.offer(supplier == null ? "" : supplier.getOAID());
                    }
                    catch (Throwable t) {
                        logger.info(t.getMessage());
                    }
                }
            });
            if (result != 0) {
                String error;
                switch (result) {
                    case 1008612: {
                        error = "Unsupported device";
                        break;
                    }
                    case 1008613: {
                        error = "Error loading configuration file";
                        break;
                    }
                    case 1008611: {
                        error = "Unsupported manufacturer";
                        break;
                    }
                    case 1008614: {
                        error = "Callback will be executed in a different thread";
                        break;
                    }
                    case 1008615: {
                        error = "Reflection call error";
                        break;
                    }
                    case 1008610: {
                        error = "Init error begin";
                        break;
                    }
                    default: {
                        error = String.valueOf(result);
                    }
                }
                logger.warning(error);
            }
            return TextUtils.isEmpty((CharSequence)(oaid = (String)oaidHolder.poll(timeout, unit))) ? null : new OaidClient.Info(oaid);
        }
        catch (Throwable t) {
            logger.info(t.getMessage());
            return null;
        }
    }
}

