/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

@JsonRootName(value="CopyPartResult")
public class CopyPartResult {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.of("UTC"));
    @JsonProperty(value="LastModified")
    private final String lastModified;
    @JsonProperty(value="ETag")
    private final String etag;

    public CopyPartResult(String lastModified, String etag) {
        this.lastModified = lastModified;
        this.etag = etag;
    }

    public static CopyPartResult from(Date date, String etag) {
        return new CopyPartResult(DATE_TIME_FORMATTER.format(date.toInstant()), etag);
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getEtag() {
        return this.etag;
    }
}

