/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class PreinstallUtil {
    private static final long SYSTEM_PROPERTY_BITMASK = 1L;
    private static final long SYSTEM_PROPERTY_REFLECTION_BITMASK = 2L;
    private static final long SYSTEM_PROPERTY_PATH_BITMASK = 4L;
    private static final long SYSTEM_PROPERTY_PATH_REFLECTION_BITMASK = 8L;
    private static final long CONTENT_PROVIDER_BITMASK = 16L;
    private static final long CONTENT_PROVIDER_INTENT_ACTION_BITMASK = 32L;
    private static final long FILE_SYSTEM_BITMASK = 64L;
    private static final long CONTENT_PROVIDER_NO_PERMISSION_BITMASK = 128L;
    private static final long ALL_LOCATION_BITMASK = 255L;

    public static boolean hasAllLocationsBeenRead(long l) {
        return (l & 0xFFL) == 255L;
    }

    public static boolean hasNotBeenRead(String string, long l) {
        String string2 = string;
        string2.getClass();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 2080271301: {
                if (!string.equals("content_provider_no_permission")) break;
                n = 7;
                break;
            }
            case 2055247442: {
                if (!string.equals("file_system")) break;
                n = 6;
                break;
            }
            case -95318717: {
                if (!string.equals("system_properties")) break;
                n = 5;
                break;
            }
            case -468656985: {
                if (!string.equals("system_properties_reflection")) break;
                n = 4;
                break;
            }
            case -480091743: {
                if (!string.equals("system_properties_path")) break;
                n = 3;
                break;
            }
            case -782042377: {
                if (!string.equals("content_provider")) break;
                n = 2;
                break;
            }
            case -1590804087: {
                if (!string.equals("system_properties_path_reflection")) break;
                n = 1;
                break;
            }
            case -1771852303: {
                if (!string.equals("content_provider_intent_action")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 7: {
                return (l & 0x80L) != 128L;
            }
            case 6: {
                return (l & 0x40L) != 64L;
            }
            case 5: {
                return (l & 1L) != 1L;
            }
            case 4: {
                return (l & 2L) != 2L;
            }
            case 3: {
                return (l & 4L) != 4L;
            }
            case 2: {
                return (l & 0x10L) != 16L;
            }
            case 1: {
                return (l & 8L) != 8L;
            }
            case 0: 
        }
        return (l & 0x20L) != 32L;
    }

    public static long markAsRead(String string, long l) {
        String string2 = string;
        string2.getClass();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 2080271301: {
                if (!string.equals("content_provider_no_permission")) break;
                n = 7;
                break;
            }
            case 2055247442: {
                if (!string.equals("file_system")) break;
                n = 6;
                break;
            }
            case -95318717: {
                if (!string.equals("system_properties")) break;
                n = 5;
                break;
            }
            case -468656985: {
                if (!string.equals("system_properties_reflection")) break;
                n = 4;
                break;
            }
            case -480091743: {
                if (!string.equals("system_properties_path")) break;
                n = 3;
                break;
            }
            case -782042377: {
                if (!string.equals("content_provider")) break;
                n = 2;
                break;
            }
            case -1590804087: {
                if (!string.equals("system_properties_path_reflection")) break;
                n = 1;
                break;
            }
            case -1771852303: {
                if (!string.equals("content_provider_intent_action")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return l;
            }
            case 7: {
                return l | 0x80L;
            }
            case 6: {
                return l | 0x40L;
            }
            case 5: {
                return l | 1L;
            }
            case 4: {
                return l | 2L;
            }
            case 3: {
                return l | 4L;
            }
            case 2: {
                return l | 0x10L;
            }
            case 1: {
                return l | 8L;
            }
            case 0: 
        }
        return l | 0x20L;
    }

    public static String getPayloadFromSystemProperty(String string, ILogger iLogger) {
        return PreinstallUtil.readSystemProperty("adjust.preinstall." + string, iLogger);
    }

    public static String getPayloadFromSystemPropertyReflection(String string, ILogger iLogger) {
        return PreinstallUtil.readSystemPropertyReflection("adjust.preinstall." + string, iLogger);
    }

    public static String getPayloadFromSystemPropertyFilePath(String string, ILogger iLogger) {
        String string2 = PreinstallUtil.readSystemProperty("adjust.preinstall.path", iLogger);
        if (string2 != null && !string2.isEmpty()) {
            if ((string2 = PreinstallUtil.readFileContent(string2, iLogger)) != null && !string2.isEmpty()) {
                return PreinstallUtil.readPayloadFromJsonString(string2, string, iLogger);
            }
            return null;
        }
        return null;
    }

    public static String getPayloadFromSystemPropertyFilePathReflection(String string, ILogger iLogger) {
        String string2 = PreinstallUtil.readSystemPropertyReflection("adjust.preinstall.path", iLogger);
        if (string2 != null && !string2.isEmpty()) {
            if ((string2 = PreinstallUtil.readFileContent(string2, iLogger)) != null && !string2.isEmpty()) {
                return PreinstallUtil.readPayloadFromJsonString(string2, string, iLogger);
            }
            return null;
        }
        return null;
    }

    public static String getPayloadFromContentProviderDefault(Context objectArray, String string, ILogger iLogger) {
        if (!Util.resolveContentProvider((Context)objectArray, "com.adjust.preinstall")) {
            return null;
        }
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[2];
        objectArray = objectArray3;
        objectArray3[0] = "com.adjust.preinstall";
        objectArray3[1] = "trackers";
        return PreinstallUtil.readContentProvider((Context)objectArray2, Util.formatString("content://%s/%s", objectArray), string, iLogger);
    }

    public static List<String> getPayloadsFromContentProviderIntentAction(Context context, String string, ILogger iLogger) {
        return PreinstallUtil.readContentProviderIntentAction(context, string, "android.permission.INSTALL_PACKAGES", iLogger);
    }

    public static List<String> getPayloadsFromContentProviderNoPermission(Context context, String string, ILogger iLogger) {
        return PreinstallUtil.readContentProviderIntentAction(context, string, null, iLogger);
    }

    public static String getPayloadFromFileSystem(String string, String string2, ILogger iLogger) {
        block5: {
            String string3;
            block4: {
                string3 = PreinstallUtil.readFileContent("/data/local/tmp/adjust.preinstall", iLogger);
                if (string3 != null && !string3.isEmpty()) break block4;
                if (string2 != null && !string2.isEmpty()) {
                    string3 = PreinstallUtil.readFileContent(string2, iLogger);
                }
                if (string3 == null || string3.isEmpty()) break block5;
            }
            return PreinstallUtil.readPayloadFromJsonString(string3, string, iLogger);
        }
        return null;
    }

    private static String readSystemProperty(String string, ILogger object) {
        try {
            return System.getProperty(string);
        }
        catch (Exception exception) {
            object = exception.getMessage();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = object;
            object.error("Exception read system property key [%s] error [%s]", objectArray2);
            return null;
        }
    }

    private static String readSystemPropertyReflection(String string, ILogger object) {
        Class<?> clazz;
        try {
            clazz = Class.forName("android.os.SystemProperties");
        }
        catch (Exception exception) {
            ILogger iLogger = object;
            object = exception.getMessage();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = object;
            iLogger.error("Exception read system property using reflection key [%s] error [%s]", objectArray2);
            return null;
        }
        return (String)clazz.getDeclaredMethod("get", String.class).invoke(clazz, string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readContentProvider(Context var0, String var1_3, String var2_4, ILogger var3_5) {
        block6: {
            block7: {
                try {
                    v0 = var0 /* !! */ .getContentResolver();
                    v1 = Uri.parse((String)var1_3);
                    v2 = new String[1];
                    v3 = v2;
                    v2[0] = "encrypted_data";
                    var0 /* !! */  = "package_name=?";
                    v4 = new String[1];
                }
                catch (Exception var0_1) {
                    break block6;
                }
                var4_6 = v4;
                {
                    v4[0] = var2_4;
                    var0 /* !! */  = v0.query(v1, v3, (String)var0 /* !! */ , var4_6, null);
                    if (var0 /* !! */  != null) break block7;
                }
                {
                    v5 = var3_5;
                    var0 /* !! */  = "Read content provider cursor null content uri [%s]";
                    v6 = new Object[1];
                }
                var2_4 = v6;
                v6[0] = var1_3;
                v5.debug((String)var0 /* !! */ , var2_4);
                return null;
            }
            if (var0 /* !! */ .moveToFirst()) ** GOTO lbl33
            v7 /* !! */  = var0 /* !! */ ;
            var0 /* !! */  = "Read content provider cursor empty content uri [%s]";
            v8 = new Object[1];
            var2_4 = v8;
            {
                v8[0] = var1_3;
                var3_5.debug((String)var0 /* !! */ , var2_4);
                v7 /* !! */ .close();
                return null;
lbl33:
                // 1 sources

                v9 = var0 /* !! */ .getString(0);
                var0 /* !! */ .close();
                return v9;
            }
        }
        var0_2 = var0_1.getMessage();
        v10 = new Object[2];
        var2_4 = v10;
        v10[0] = var1_3;
        v10[1] = var0_2;
        var3_5.error("Exception read content provider uri [%s] error [%s]", var2_4);
        return null;
    }

    private static List<String> readContentProviderIntentAction(Context context, String string, String string2, ILogger iLogger) {
        ArrayList<String> arrayList;
        int n = Build.VERSION.SDK_INT;
        if (n < 19) {
            return null;
        }
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        for (Object object : n >= 33 ? context.getPackageManager().queryIntentContentProviders(new Intent("com.attribution.REFERRAL_PROVIDER"), PackageManager.ResolveInfoFlags.of((long)0L)) : context.getPackageManager().queryIntentContentProviders(new Intent("com.attribution.REFERRAL_PROVIDER"), 0)) {
            if (string2 != null && context.getPackageManager().checkPermission(string2, ((ResolveInfo)object).providerInfo.packageName) != 0 || (object = ((ResolveInfo)object).providerInfo.authority) == null || ((String)object).isEmpty()) continue;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            objectArray[1] = "trackers";
            object = PreinstallUtil.readContentProvider(context, Util.formatString("content://%s/%s", objectArray2), string, iLogger);
            if (object == null || ((String)object).isEmpty()) continue;
            arrayList2.add((String)object);
        }
        if (!arrayList2.isEmpty()) {
            return arrayList2;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static String readFileContent(String var0, ILogger var1_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 60->63)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String readPayloadFromJsonString(String string, String objectArray, ILogger iLogger) {
        try {
            return new JSONObject(string.trim()).optString((String)objectArray);
        }
        catch (Exception exception) {
            string = exception.getMessage();
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
            iLogger.error("Exception read payload from json string error [%s]", objectArray);
            return null;
        }
    }
}

