/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.player.statistics.http;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.live.player.statistics.StatisticsReport;
import tv.athena.live.player.statistics.http.HttpUrlConnectionUtil;
import tv.athena.live.player.statistics.http.IStatisticsHttp;
import tv.athena.live.utils.ALog;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0084\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0006H$J\b\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0004H$J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0012\u0010\u0019\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0004J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ltv/athena/live/player/statistics/http/AbstractStatisticsHttp;", "Ltv/athena/live/player/statistics/http/IStatisticsHttp;", "()V", "mRetryTime", "", "mTestUrlAddr", "", "reasonPhrase", "statusCode", "get", "", "urlAddr", "content", "getByUrlConn", "getLastStatusCode", "getServerAddr", "getTestUrlAddr", "getUrlAddr", "reset", "", "sendContent", "var1", "var2", "var3", "sendSync", "sendSyncByTrying", "setTestServer", "testServer", "Companion", "statistics_release"})
public abstract class AbstractStatisticsHttp
implements IStatisticsHttp {
    private int mRetryTime = 2;
    private String mTestUrlAddr;
    private int statusCode;
    private String reasonPhrase;
    private static final String TAG;
    public static final Companion Companion;

    private final String getServerAddr() {
        return StatisticsReport.Companion.getInstance().isDebug() ? this.getTestUrlAddr() : this.getUrlAddr();
    }

    @Override
    public void setTestServer(@NotNull String testServer) {
        Intrinsics.checkParameterIsNotNull((Object)testServer, (String)"testServer");
        this.mTestUrlAddr = testServer;
    }

    @Override
    public boolean sendSync(@NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        ALog.i((String)TAG, (String)("to send content = " + content));
        return this.sendSyncByTrying(content);
    }

    protected final boolean sendSyncByTrying(@Nullable String content) {
        return this.sendContent(this.getServerAddr(), content, this.mRetryTime);
    }

    protected final boolean get(@NotNull String urlAddr, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)urlAddr, (String)"urlAddr");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        return this.getByUrlConn(urlAddr, content);
    }

    private final boolean getByUrlConn(String urlAddr, String content) {
        this.statusCode = -1;
        this.reasonPhrase = null;
        HttpUrlConnectionUtil.HttpResp resp = HttpUrlConnectionUtil.getByUrlConn(urlAddr, content);
        this.statusCode = resp.statusCode;
        this.reasonPhrase = resp.reason;
        return resp.isSucceed;
    }

    @Override
    public int getLastStatusCode() {
        return this.statusCode;
    }

    protected abstract boolean sendContent(@Nullable String var1, @Nullable String var2, int var3);

    @Nullable
    protected abstract String getUrlAddr();

    @Nullable
    public String getTestUrlAddr() {
        return this.mTestUrlAddr;
    }

    @Override
    public void reset() {
        this.mRetryTime = 2;
    }

    static {
        Companion = new Companion(null);
        TAG = AbstractStatisticsHttp.class.getSimpleName();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Ltv/athena/live/player/statistics/http/AbstractStatisticsHttp$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "TAG$annotations", "statistics_release"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void TAG$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

