/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.report.cache;

import android.os.Handler;
import java.util.HashMap;
import java.util.Map;
import tv.athena.live.component.business.report.cache.AudioCacheConfig;
import tv.athena.live.component.business.report.cache.UserCachedAudio;
import tv.athena.live.utils.ALog;

public class RoomCachedAudio {
    private HashMap<Long, UserCachedAudio> mAudioData = new HashMap();
    private static final String TAG = "RoomCachedAudio";
    private boolean mWillCheck;
    private Handler mHandler = new Handler();
    private Runnable mDiscardExpiredDataRunnable = new Runnable(){

        @Override
        public void run() {
            RoomCachedAudio.this.discardExpiredData();
            RoomCachedAudio.this.mWillCheck = false;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheAudioData(Long uid, byte[] audioData, long duration) {
        UserCachedAudio userAudio = this.mAudioData.get(uid);
        if (null == userAudio) {
            userAudio = new UserCachedAudio();
            RoomCachedAudio roomCachedAudio = this;
            synchronized (roomCachedAudio) {
                this.mAudioData.put(uid, userAudio);
            }
            ALog.i((String)TAG, (String)("cache user " + uid));
        }
        if (audioData != null && audioData.length > 0) {
            long curTime = System.currentTimeMillis();
            userAudio.discardExpiredData(curTime - AudioCacheConfig.mCacheDuration);
            userAudio.addData(audioData, curTime, duration);
            this.toCheckExpiredData();
        }
    }

    public byte[] getUserCachedAudio(long uid, long expiredTime) {
        UserCachedAudio userAudio = this.mAudioData.get(uid);
        if (userAudio != null) {
            return userAudio.getCachedAudio(expiredTime);
        }
        return null;
    }

    public synchronized HashMap<Long, byte[]> getCachedAudio(long expiredTime) {
        HashMap<Long, byte[]> cachedAudio = new HashMap<Long, byte[]>();
        for (Map.Entry<Long, UserCachedAudio> entry : this.mAudioData.entrySet()) {
            UserCachedAudio userCachedAudio = entry.getValue();
            byte[] data = userCachedAudio.getCachedAudio(expiredTime);
            if (data == null) continue;
            cachedAudio.put(entry.getKey(), data);
        }
        return cachedAudio;
    }

    public void reset() {
        this.mHandler.removeCallbacks(this.mDiscardExpiredDataRunnable);
        this.mWillCheck = false;
    }

    private void toCheckExpiredData() {
        if (this.mWillCheck) {
            return;
        }
        this.mHandler.postDelayed(this.mDiscardExpiredDataRunnable, AudioCacheConfig.mCacheDuration);
        this.mWillCheck = true;
    }

    private synchronized void discardExpiredData() {
        long expieredTime = System.currentTimeMillis() - AudioCacheConfig.mCacheDuration;
        for (UserCachedAudio userCachedAudio : this.mAudioData.values()) {
            userCachedAudio.discardExpiredData(expieredTime);
        }
        ALog.i((String)"AudioCacheService", (String)("after discardExpiredData, cached size: " + AudioCacheConfig.mCurCachedSize));
    }
}

