/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.report.cache;

import android.text.TextUtils;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import tv.athena.live.component.business.report.cache.AudioCacheConfig;
import tv.athena.live.component.business.report.cache.RoomCachedAudio;
import tv.athena.live.utils.ALog;

public enum AudioCacheService {
    INSTANCE;

    private HashMap<String, RoomCachedAudio> mAudioData = new HashMap();
    private static final String TAG = "AudioCacheService";
    private final AtomicInteger mLogAtomicInteger = new AtomicInteger();

    public synchronized void cacheAudioData(String roomId, Long uid, byte[] audioData, long duration) {
        if (this.mLogAtomicInteger.incrementAndGet() >= 500) {
            this.mLogAtomicInteger.set(0);
            ALog.i((String)TAG, (String)("cacheAudioData roomId: " + roomId + ", uid: " + uid + ", duration: " + duration));
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            return;
        }
        RoomCachedAudio roomAudio = this.mAudioData.get(roomId);
        if (null == roomAudio) {
            roomAudio = new RoomCachedAudio();
            this.mAudioData.put(roomId, roomAudio);
        }
        roomAudio.cacheAudioData(uid, audioData, duration);
    }

    public synchronized byte[] getCachedUserAudio(String roomId, long uid, long expiredTime) {
        RoomCachedAudio roomAudio = this.mAudioData.get(roomId);
        if (roomAudio != null) {
            byte[] cachedAudio = roomAudio.getUserCachedAudio(uid, expiredTime);
            ALog.i((String)TAG, (String)("after getusercache, cached size: " + AudioCacheConfig.mCurCachedSize));
            return cachedAudio;
        }
        return null;
    }

    public synchronized void clearRoomCache(String roomId) {
        ALog.i((String)TAG, (String)("clear room cahce, roomId: " + roomId));
        RoomCachedAudio roomAudio = this.mAudioData.remove(roomId);
        if (roomAudio != null) {
            roomAudio.reset();
        }
    }

    public synchronized HashMap<Long, byte[]> getRoomCachedAudio(String roomId, long expiredTime) {
        RoomCachedAudio roomAudio = this.mAudioData.get(roomId);
        if (roomAudio != null) {
            HashMap<Long, byte[]> cachedAudio = roomAudio.getCachedAudio(expiredTime);
            ALog.i((String)TAG, (String)("after getroomcache, cached size: " + AudioCacheConfig.mCurCachedSize));
            return cachedAudio;
        }
        return null;
    }
}

