/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.audience.repository.service.impl;

import android.arch.lifecycle.MutableLiveData;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.yy.liveplatform.proto.nano.LpfChannel;
import com.yy.liveplatform.proto.nano.LpfUser;
import java.util.Arrays;
import java.util.List;
import tv.athena.live.component.business.audience.repository.service.IAudienceService;
import tv.athena.live.utils.ServiceUtils;
import tv.athena.service.api.IMessageCallback;
import tv.athena.service.api.event.ServiceBroadcastEvent;

public class AudienceService
implements IAudienceService {
    private static final String FUNC_GET_CHANNEL_USERS = "getChannelUsers";
    private static final String FUNC_CHANNEL_USER_NOTICE_BROADCAST = "channelUserNoticeBroadcast";
    private static final String FUNC_CHANNEL_USER_COUNT_BROADCAST = "channelUserCountBroadcast";
    private static final String SERVICE_NAME = "lpfChannel";

    @Override
    public void getChannelUsers(LpfChannel.GetChannelUsersReq req, IMessageCallback<LpfChannel.GetChannelUsersResp> callback) {
        ServiceUtils.ServiceReq serviceReq = new ServiceUtils.ServiceReq();
        serviceReq.mReqParam = req;
        serviceReq.mFunctionName = FUNC_GET_CHANNEL_USERS;
        serviceReq.mServerName = SERVICE_NAME;
        ServiceUtils.send((ServiceUtils.ServiceReq)serviceReq, callback);
    }

    @Override
    public boolean handleUserNoticeBroadcast(MutableLiveData<List<LpfUser.UserInfo>> users, MutableLiveData<String> userCount, ServiceBroadcastEvent event) {
        if (event == null) {
            return false;
        }
        try {
            if (FUNC_CHANNEL_USER_NOTICE_BROADCAST.equals(event.getFuncName())) {
                LpfChannel.ChannelUserNoticeBroadcast broadcast = LpfChannel.ChannelUserNoticeBroadcast.parseFrom((byte[])event.getMessage());
                users.setValue(Arrays.asList(broadcast.users));
                return true;
            }
            if (FUNC_CHANNEL_USER_COUNT_BROADCAST.equals(event.getFuncName())) {
                LpfChannel.ChannelUserCountBroadcast broadcast = LpfChannel.ChannelUserCountBroadcast.parseFrom((byte[])event.getMessage());
                userCount.setValue((Object)String.valueOf(broadcast.userCount));
            }
        }
        catch (InvalidProtocolBufferNanoException e) {
            e.printStackTrace();
        }
        return false;
    }
}

