/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.audience;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import com.yy.liveplatform.proto.nano.LpfChannel;
import com.yy.liveplatform.proto.nano.LpfUser;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.annotation.MessageBinding;
import tv.athena.core.sly.Sly;
import tv.athena.live.api.audience.AudienceApi;
import tv.athena.live.base.arch.IComponentViewModel;
import tv.athena.live.base.manager.ComponentContext;
import tv.athena.live.component.business.audience.repository.AudienceRepository;
import tv.athena.live.utils.ALog;
import tv.athena.live.utils.ThreadSafeMutableLiveData;
import tv.athena.service.api.IMessageCallback;
import tv.athena.service.api.MessageResponse;
import tv.athena.service.api.ServiceFailResult;
import tv.athena.service.api.event.ServiceBroadcastEvent;

public class AudienceViewModel
implements IComponentViewModel {
    private static final String TAG = AudienceViewModel.class.getSimpleName();
    private static final int DEFAULT_PAGE_SIZE = 50;
    private ComponentContext mContext;
    private AudienceRepository mRepository;
    private MutableLiveData<List<LpfUser.UserInfo>> mUsers = new ThreadSafeMutableLiveData();
    private MutableLiveData<String> mUserCount = new ThreadSafeMutableLiveData();
    private Observer<Long> mSidObserver = new Observer<Long>(){

        public void onChanged(@Nullable Long sid) {
            AudienceViewModel.this.getChannelUsers(sid, 50, 0);
        }
    };

    public AudienceViewModel(ComponentContext context) {
        this.mContext = context;
        this.mRepository = new AudienceRepository();
        Sly.Companion.subscribe((Object)this);
        this.mContext.getCommonViewModel().observeSidForever(this.mSidObserver);
    }

    private void getChannelUsers(long sid, int pageSize, int offset) {
        this.mRepository.getChannelUsers(sid, pageSize, offset, new IMessageCallback<LpfChannel.GetChannelUsersResp>(){

            public void onMessageSuccess(@NotNull MessageResponse<LpfChannel.GetChannelUsersResp> messageResponse) {
                if (messageResponse == null || messageResponse.getMessage() == null) {
                    return;
                }
                AudienceViewModel.this.mUsers.setValue(Arrays.asList(((LpfChannel.GetChannelUsersResp)messageResponse.getMessage()).users));
            }

            public void onMessageFail(@NotNull ServiceFailResult serviceFailResult, @Nullable Exception e) {
                ALog.w((String)TAG, (String)serviceFailResult.toString());
            }

            @NotNull
            public LpfChannel.GetChannelUsersResp get() {
                return new LpfChannel.GetChannelUsersResp();
            }
        });
    }

    public void getChannelUsers(int pageSize, int offset, final AudienceApi.OnChannelQueryListener listener) {
        long sid = this.mContext.getCommonViewModel().getSid();
        this.mRepository.getChannelUsers(sid, pageSize, offset, new IMessageCallback<LpfChannel.GetChannelUsersResp>(){

            public void onMessageSuccess(@NotNull MessageResponse<LpfChannel.GetChannelUsersResp> messageResponse) {
                if (messageResponse == null || messageResponse.getMessage() == null) {
                    return;
                }
                if (listener != null) {
                    listener.onSuccess(Arrays.asList(((LpfChannel.GetChannelUsersResp)messageResponse.getMessage()).users));
                }
            }

            public void onMessageFail(@NotNull ServiceFailResult serviceFailResult, @Nullable Exception e) {
                ALog.w((String)TAG, (String)serviceFailResult.toString());
                if (listener != null) {
                    listener.onFail(serviceFailResult.getResultCode(), serviceFailResult.toString());
                }
            }

            @NotNull
            public LpfChannel.GetChannelUsersResp get() {
                return new LpfChannel.GetChannelUsersResp();
            }
        });
    }

    public void observeChannelUsers(LifecycleOwner owner, Observer<List<LpfUser.UserInfo>> observer) {
        this.mUsers.observe(owner, observer);
    }

    public void observeUserCount(LifecycleOwner owner, Observer<String> observer) {
        this.mUserCount.observe(owner, observer);
    }

    public void onDestroy() {
        Sly.Companion.unSubscribe((Object)this);
        this.mContext.getCommonViewModel().removeSidObserver(this.mSidObserver);
    }

    @MessageBinding
    public void onBroadcastGroupEvent(ServiceBroadcastEvent event) {
        if (event == null) {
            return;
        }
        if (this.mRepository.handleUserNoticeBroadcast(this.mUsers, this.mUserCount, event)) {
            return;
        }
    }
}

