/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar.webview.jsapi;

import android.annotation.TargetApi;
import android.os.Handler;
import android.os.Looper;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import java.lang.ref.WeakReference;
import tv.athena.live.api.activitybar.service.IJsApiModule;
import tv.athena.live.api.activitybar.service.IJsSupportWebApi;
import tv.athena.live.component.business.activitybar.webview.jsapi.ApiModuleManager;
import tv.athena.live.component.business.activitybar.webview.model.ResultData;
import tv.athena.live.component.business.activitybar.webview.util.JsonParser;
import tv.athena.live.utils.ALog;

public class JavaScriptInterface {
    private static final String TAG = "JavaScriptInterface";
    private WeakReference<WebView> webViewHolder = null;
    private WeakReference<IJsSupportWebApi> jsWebApiHodler = null;
    public static final String INVOKE_WEB_METHOD = "javascript:try{window.YYApiCore.invokeWebMethod('%s',JSON.parse(%s))}catch(e){if(console)console.log(e)}";
    private ApiModuleManager v2ApiModuleManager = new ApiModuleManager();
    private Handler mtHandler = new Handler(Looper.getMainLooper());

    public JavaScriptInterface(WebView view, IJsSupportWebApi webApi) {
        if (view != null) {
            this.webViewHolder = new WeakReference<WebView>(view);
        }
        if (webApi != null) {
            this.jsWebApiHodler = new WeakReference<IJsSupportWebApi>(webApi);
        }
    }

    public void addApiModule(IJsApiModule module) {
        this.v2ApiModuleManager.addModule(module);
    }

    public void removeApiModule(String moduleName) {
        this.v2ApiModuleManager.removeModuleByName(moduleName);
    }

    @TargetApi(value=11)
    public void release() {
        if (this.v2ApiModuleManager != null) {
            this.v2ApiModuleManager.release();
        }
    }

    @JavascriptInterface
    public String invoke(String module, String name, String parameters, String callback) {
        ALog.i((String)TAG, (String)("JavascriptInterface invoke module = " + module + ", name = " + name + ", parameters = " + parameters + ", callback = " + callback));
        try {
            IJsApiModule apiModule = this.v2ApiModuleManager.getModule(module);
            if (apiModule != null) {
                IJsSupportWebApi webApi = null;
                if (this.jsWebApiHodler != null) {
                    webApi = (IJsSupportWebApi)this.jsWebApiHodler.get();
                }
                String result = apiModule.invoke(name, parameters, callback, webApi);
                return result;
            }
        }
        catch (Throwable e) {
            ALog.e((String)TAG, (String)("invoke module = " + module + ", name = " + name + ", parameters = " + parameters + ", error happen e = " + e), (Throwable)e);
        }
        return JsonParser.toJson(new ResultData(-1));
    }

    private void invokeJSCallback(String cbName, String jsonParam) {
        WebView webView;
        if (this.webViewHolder != null && (webView = (WebView)this.webViewHolder.get()) != null) {
            this.mtHandler.post(() -> {
                try {
                    String invokeStr = String.format(INVOKE_WEB_METHOD, cbName, jsonParam);
                    webView.loadUrl(invokeStr);
                }
                catch (Exception e) {
                    ALog.e((String)TAG, (String)"", (Throwable)e);
                }
            });
        }
    }

    private IJsApiModule.IJSCallback genJSCallback(String callbackName) {
        if (callbackName != null && callbackName.length() > 0) {
            return param -> this.invokeJSCallback(callbackName, param);
        }
        return null;
    }
}

