/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar.webview;

import android.net.Uri;
import android.text.TextUtils;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import tv.athena.live.utils.ALog;

public class UrlParser {
    private static final String TAG = "UrlParser";

    public static Map<String, String> getUrlParams(String url) {
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        URL mUrl = UrlParser.stringToURL(url);
        if (mUrl == null) {
            return queryPairs;
        }
        try {
            String query = mUrl.getQuery();
            if (query == null) {
                return queryPairs;
            }
            if (query.contains("url=")) {
                int index = query.indexOf("url=");
                String urlValue = query.substring(index + 4);
                queryPairs.put("url", URLDecoder.decode(urlValue, "UTF-8"));
                query = query.substring(0, index);
            }
            if (query.length() > 0) {
                String[] pairs;
                for (String pair : pairs = query.split("&")) {
                    int idx = pair.indexOf("=");
                    if (idx <= 0 || idx >= pair.length() - 1) continue;
                    String key = URLDecoder.decode(pair.substring(0, idx), "UTF-8");
                    String value = URLDecoder.decode(pair.substring(idx + 1), "UTF-8");
                    queryPairs.put(key, value);
                }
            }
        }
        catch (Exception ex) {
            ALog.e((String)TAG, (String)ex.toString(), (Throwable)ex);
        }
        return queryPairs;
    }

    public static String getUrlParamStr(String url) {
        URL mUrl = UrlParser.stringToURL(url);
        if (mUrl == null) {
            return "";
        }
        try {
            String query = mUrl.getQuery();
            return query;
        }
        catch (Exception ex) {
            ALog.e((String)TAG, (String)ex.toString(), (Throwable)ex);
            return "";
        }
    }

    public static String getUrlHostAndPath(String url) {
        if (url.contains("?")) {
            return url.substring(0, url.indexOf("?"));
        }
        return url;
    }

    public static String getUriParam(Uri uri, String paramKey) {
        if (uri == null || paramKey == null || paramKey.length() == 0) {
            return "";
        }
        String paramValue = uri.getQueryParameter(paramKey);
        if (paramValue == null) {
            paramValue = "";
        }
        return paramValue;
    }

    public static int getIntUriParam(Uri uri, String paramKey) {
        if (uri == null || paramKey == null || paramKey.length() == 0) {
            return 0;
        }
        try {
            String paramValue = uri.getQueryParameter(paramKey);
            if (paramValue == null || paramValue.length() == 0) {
                return 0;
            }
            return Integer.parseInt(paramValue);
        }
        catch (Exception ex) {
            ALog.e((String)TAG, (String)ex.toString(), (Throwable)ex);
            return 0;
        }
    }

    private static URL stringToURL(String url) {
        if (url == null || url.length() == 0 || !url.contains("://")) {
            return null;
        }
        try {
            StringBuilder sbUrl = new StringBuilder("http");
            sbUrl.append(url.substring(url.indexOf("://")));
            URL mUrl = new URL(sbUrl.toString());
            return mUrl;
        }
        catch (Exception ex) {
            ALog.e((String)TAG, (String)ex.toString(), (Throwable)ex);
            return null;
        }
    }

    public static String addParams(String url, String key, String value) {
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            ALog.w((String)TAG, (String)("params error url:" + url + " key:" + key + " value:" + value));
            return url;
        }
        Uri.Builder builder = Uri.parse((String)url).buildUpon();
        builder.appendQueryParameter(key, value);
        return builder.build().toString();
    }

    public static String addParams(String url, Map<String, String> params) {
        if (TextUtils.isEmpty((CharSequence)url) || params == null || params.isEmpty()) {
            ALog.w((String)TAG, (String)("params error url:" + url));
            return url;
        }
        Uri.Builder builder = Uri.parse((String)url).buildUpon();
        Set<String> paramsSet = params.keySet();
        for (String param : paramsSet) {
            builder.appendQueryParameter(param, params.get(param));
        }
        return builder.build().toString();
    }

    public static String replaceParam(String url, String replaceKey, String replaceValue, boolean isAdd) {
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)replaceKey) || TextUtils.isEmpty((CharSequence)replaceValue)) {
            ALog.w((String)TAG, (String)("params error url:" + url + " replaceKey:" + replaceKey + " replaceValue:" + replaceValue));
            return url;
        }
        String hostAndPath = UrlParser.getUrlHostAndPath(url);
        Map<String, String> params = UrlParser.getUrlParams(url);
        if (!params.containsKey(replaceKey) && !isAdd) {
            return url;
        }
        params.put(replaceKey, replaceValue);
        String newUrl = hostAndPath;
        newUrl = UrlParser.addParams(newUrl, params);
        return newUrl;
    }
}

