/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar;

import android.text.TextUtils;
import com.yy.liveplatform.proto.nano.LpfActivity;
import tv.athena.annotation.MessageBinding;
import tv.athena.core.sly.Sly;
import tv.athena.live.api.activitybar.ActivityBarApi;
import tv.athena.live.base.mvvmImpl.MvvmComponent;
import tv.athena.live.component.business.activitybar.ActivityBarApiImpl;
import tv.athena.live.component.business.activitybar.ActivityBarView;
import tv.athena.live.component.business.activitybar.ActivityBarViewModel;
import tv.athena.live.component.business.activitybar.webview.jsapi.JsApiModuleEx;
import tv.athena.live.utils.ALog;
import tv.athena.service.api.event.ServiceBroadcastEvent;
import tv.athena.service.api.event.ServiceUnicastEvent;

public class ActivityBarComponent
extends MvvmComponent<ActivityBarApi, ActivityBarView, ActivityBarViewModel> {
    private static final String TAG = "ActivityBarComponent";

    public void onCreate() {
        Sly.Companion.subscribe((Object)this);
    }

    protected ActivityBarApi onCreateApi() {
        ActivityBarApiImpl impl = new ActivityBarApiImpl();
        impl.setContext(this.mComponentContext);
        return impl;
    }

    protected ActivityBarView onCreateView() {
        ActivityBarView view = new ActivityBarView();
        view.setContext(this.mComponentContext);
        return view;
    }

    protected ActivityBarViewModel onCreateViewModel() {
        return new ActivityBarViewModel(this.mComponentContext);
    }

    public void onAllComponentsReady() {
        ((ActivityBarApiImpl)this.getApi()).bindActivityBarView((ActivityBarView)this.mView);
    }

    @MessageBinding
    public void onActivityDataBroadcastEvent(ServiceUnicastEvent event) {
        if (event == null || TextUtils.isEmpty((CharSequence)event.getFuncName())) {
            return;
        }
        this.onActivityBroadcast(event.getFuncName(), "ActivityWindow", event.getMessage());
        this.onActivityDataBroadcast(event.getFuncName(), "ActivityData", event.getMessage());
    }

    @MessageBinding
    public void onActivityBroadcastEvent(ServiceBroadcastEvent event) {
        if (event == null) {
            return;
        }
        this.onActivityBroadcast(event.getFuncName(), null, event.getMessage());
        this.onActivityDataBroadcast(event.getFuncName(), null, event.getMessage());
    }

    private void onActivityBroadcast(String func, String type, byte[] message) {
        if (func.equals("activityWindowListBroadcast")) {
            try {
                ALog.e((String)TAG, (String)("ActivityBroadcast: " + func));
                LpfActivity.ActivityWindowListBroadcast mWindowList = LpfActivity.ActivityWindowListBroadcast.parseFrom((byte[])message);
                this.saveData(mWindowList.showUrl, mWindowList.activityWindowData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void saveData(String url, String data) {
        ((ActivityBarApiImpl)this.getApi()).saveBroadcastData(url, data);
    }

    private void onActivityDataBroadcast(String func, String type, byte[] message) {
        if (func.equals("activityDataBroadcast")) {
            try {
                ALog.e((String)TAG, (String)("ActivityDataBroadcast: " + func));
                LpfActivity.ActivityWindowListBroadcast mWindowData = LpfActivity.ActivityWindowListBroadcast.parseFrom((byte[])message);
                this.saveData(null, mWindowData.activityWindowData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.getApi() != null) {
            ((ActivityBarApiImpl)this.getApi()).clearObserver();
        }
        JsApiModuleEx.INSTANCE.clear();
        ((ActivityBarView)this.getView()).close();
        Sly.Companion.unSubscribe((Object)this);
    }

    public void onLeave() {
    }
}

