/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.report;

import android.content.Context;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import com.yy.liveplatform.proto.nano.LpfAudit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import tv.athena.live.api.report.ReportApi;
import tv.athena.live.base.arch.IComponentViewModel;
import tv.athena.live.base.manager.ComponentContext;
import tv.athena.live.basesdk.liveroom.LivePlatformSdk;
import tv.athena.live.basesdk.thunderblotwrapper.AbscThunderEventListener;
import tv.athena.live.basesdk.thunderblotwrapper.ThunderHandle;
import tv.athena.live.component.business.report.cache.AudioCacheService;
import tv.athena.live.component.business.report.repository.ReportRepository;
import tv.athena.live.utils.ALog;
import tv.athena.live.utils.UploadUtil;
import tv.athena.service.api.IMessageCallback;
import tv.athena.service.api.MessageResponse;
import tv.athena.service.api.ServiceFailResult;
import tv.athena.util.common.FileUtils;

public class ReportService
extends AbscThunderEventListener
implements IComponentViewModel {
    private static final String TAG = ReportService.class.getSimpleName();
    private static final String DIR_NAME = ".audioOutput";
    private ReportRepository mRepository = new ReportRepository();
    private ComponentContext mComponentContext;
    private ThunderHandle mThunderHandle;

    public ReportService(ComponentContext context) {
        this.mComponentContext = context;
        this.mThunderHandle = context.getThunderHandle();
    }

    private String getRoomId() {
        if (this.mComponentContext != null && this.mComponentContext.getCommonViewModel() != null) {
            return this.mComponentContext.getCommonViewModel().getSid() + "";
        }
        return "";
    }

    public void init() {
        ALog.i((String)TAG, (String)"init");
        this.mThunderHandle.registerThunderEventListener((AbscThunderEventListener)this);
        this.mThunderHandle.enableAudioDataIndication(true);
    }

    public void onJoinRoomSuccess(String room, String uid, int elapsed) {
        ALog.i((String)TAG, (String)"onJoinRoomSuccess");
        super.onJoinRoomSuccess(room, uid, elapsed);
    }

    public void onAudioPlayData(byte[] data, long cpt, long pts, String uid, long duration) {
        super.onAudioPlayData(data, cpt, pts, uid, duration);
        if (TextUtils.isEmpty((CharSequence)this.getRoomId())) {
            ALog.i((String)TAG, (String)"onAudioPlayData roomId is empty! ");
            return;
        }
        AudioCacheService.INSTANCE.cacheAudioData(this.getRoomId(), Long.parseLong(uid), data, duration);
    }

    public void report(Context context, final long reportedUid, final int illegalType, final int auditType, final ReportApi.OnReportListener listener, final String ext) {
        if (2 == auditType) {
            this.sendReport("", reportedUid, illegalType, auditType, listener, ext);
        } else {
            byte[] audioData = AudioCacheService.INSTANCE.getCachedUserAudio(this.getRoomId(), reportedUid, System.currentTimeMillis() - 20000L);
            if (audioData != null && audioData.length > 0) {
                final String savePath = this.writeAudioToFile(audioData);
                if (savePath == null) {
                    ALog.i((String)TAG, (String)"failed to save audio file");
                    if (listener != null) {
                        listener.onFailed(-1, "failed to save audio file");
                    }
                    return;
                }
                UploadUtil.getInstance().upload(context, savePath, new UploadUtil.UploadCallBack(){

                    public void onSuccess(String url) {
                        ALog.i((String)TAG, (String)("upload success url = " + url));
                        ReportService.this.sendReport(url, reportedUid, illegalType, auditType, listener, ext);
                        FileUtils.delete((String)savePath);
                    }

                    public void onFail() {
                        if (listener != null) {
                            listener.onFailed(-1, "failed to upload");
                        }
                        ALog.i((String)TAG, (String)"upload failed url");
                        FileUtils.delete((String)savePath);
                    }
                });
            } else {
                ALog.w((String)TAG, (String)"audioData is empty");
                this.sendReport("", reportedUid, illegalType, 2, listener, ext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeAudioToFile(byte[] audioData) {
        if (audioData == null || audioData.length == 0 || !this.hasWriteExternalStoragePermission()) {
            return null;
        }
        String saveDir = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + DIR_NAME;
        FileUtils.createOrExistsDir((String)saveDir);
        FileOutputStream fos = null;
        try {
            String savePath = saveDir + File.separator + "report_" + System.currentTimeMillis();
            fos = new FileOutputStream(savePath);
            fos.write(audioData);
            fos.flush();
            String string = savePath;
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private boolean hasWriteExternalStoragePermission() {
        return ContextCompat.checkSelfPermission((Context)LivePlatformSdk.getInstance().getApplication(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    private void sendReport(String content, long reportedUid, int illegalType, int auditType, final ReportApi.OnReportListener listener, String ext) {
        this.mRepository.reportContent(Long.parseLong(this.getRoomId()), reportedUid, this.mComponentContext.getCommonViewModel().getMyUid(), 8, auditType, content, illegalType, auditType != 2, ext, new IMessageCallback<LpfAudit.AuditReportResp>(){

            public void onMessageSuccess(MessageResponse<LpfAudit.AuditReportResp> messageResponse) {
                int code = messageResponse != null && messageResponse.getMessage() != null ? ((LpfAudit.AuditReportResp)messageResponse.getMessage()).code : -1;
                ALog.i((String)TAG, (String)("senReport success reason code = " + code));
                if (code != 0) {
                    if (listener != null) {
                        listener.onFailed(code, ((LpfAudit.AuditReportResp)messageResponse.getMessage()).message);
                    }
                } else if (listener != null) {
                    listener.onSuccess(messageResponse != null ? ((LpfAudit.AuditReportResp)messageResponse.getMessage()).data : "");
                }
            }

            public void onMessageFail(ServiceFailResult serviceFailResult, Exception e) {
                ALog.i((String)TAG, (String)("senReport failed reason = " + (serviceFailResult != null ? serviceFailResult.toString() : "")));
                if (listener != null) {
                    listener.onFailed(serviceFailResult != null ? serviceFailResult.getResultCode() : -1, serviceFailResult != null ? serviceFailResult.getDescription() : "");
                }
            }

            @NotNull
            public LpfAudit.AuditReportResp get() {
                return new LpfAudit.AuditReportResp();
            }
        });
    }

    private synchronized byte[] getCachedUserAudio(long uid, long expiredTime) {
        return AudioCacheService.INSTANCE.getCachedUserAudio(this.getRoomId(), uid, expiredTime);
    }

    public void close() {
        ALog.i((String)TAG, (String)"close");
        this.mThunderHandle.unRegisterRtcEventListener((AbscThunderEventListener)this);
        AudioCacheService.INSTANCE.clearRoomCache(this.getRoomId());
    }
}

