/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar.webview.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import tv.athena.live.utils.ALog;

public class JsonParser {
    public static Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    public static <T> T parseJsonObject(String json, Class<T> clz) {
        return (T)gson.fromJson(json, clz);
    }

    public static <T> T parseJsonObject(JsonElement json, Class<T> clz) {
        return (T)gson.fromJson(json, clz);
    }

    public static <T> T[] parseJsonArray(String json, Class<T> clz) {
        Object[] result = (Object[])gson.fromJson(json, new TypeToken<T[]>(){}.getType());
        return result;
    }

    public static <K, V> Map<K, V> parseJsonMap(String json, Class<K> keyType, Class<V> valueType) {
        Map result = (Map)gson.fromJson(json, new TypeToken<Map<K, V>>(){}.getType());
        return result;
    }

    public static String toJson(Object obj) {
        try {
            return gson.toJson(obj);
        }
        catch (Throwable e) {
            ALog.e((String)"JsonParser", (String)"wangsong", (Throwable)e);
            return "{}";
        }
    }

    public static <T> List<T> parseJsonList(String json, Class<T> clz) throws Exception {
        ArrayList<Object> data = new ArrayList<Object>();
        if (!TextUtils.isEmpty((CharSequence)json)) {
            com.google.gson.JsonParser parser = new com.google.gson.JsonParser();
            JsonElement element = parser.parse(json);
            JsonArray array = element.getAsJsonArray();
            for (JsonElement jo : array) {
                data.add(gson.fromJson(jo, clz));
            }
        }
        return data;
    }

    public static <T> List<T> parseJsonList(JsonArray array, Class<T> clz) throws Exception {
        ArrayList<T> data = new ArrayList<T>();
        for (JsonElement jo : array) {
            data.add(JsonParser.parseJsonObject(jo, clz));
        }
        return data;
    }

    public static String getJson(String fileName, Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            AssetManager assetManager = context.getAssets();
            BufferedReader bf = new BufferedReader(new InputStreamReader(assetManager.open(fileName)));
            while ((line = bf.readLine()) != null) {
                stringBuilder.append(line);
            }
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }

    private static class NumberTypeAdapter
    implements JsonSerializer<Number> {
        private NumberTypeAdapter() {
        }

        public JsonElement serialize(Number src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }
    }
}

