/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar.webview.util;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class HttpsParser {
    private static ConcurrentMap<String, Integer> hostMap;
    private static final String FORCE = "force";
    private static final String HTTP = "http:";
    private static final String HTTPS = "https:";

    public static String getHost(String url) {
        if (url == null || !url.startsWith("http")) {
            return null;
        }
        try {
            URI uri = new URI(url);
            return uri.getHost() == null ? url : uri.getHost();
        }
        catch (Throwable throwable) {
            return url;
        }
    }

    public static boolean needsConvert(String host) {
        if (hostMap == null || hostMap.size() <= 0) {
            return false;
        }
        if (hostMap.containsKey(host)) {
            return (Integer)hostMap.get(host) == 1;
        }
        return hostMap.containsKey(FORCE) && (Integer)hostMap.get(FORCE) == 1;
    }

    public static String convertToHttps(String url) {
        if (url == null || url.isEmpty() || !url.startsWith(HTTP)) {
            return url;
        }
        String host = HttpsParser.getHost(url);
        if (host == null || host.isEmpty() || host.startsWith(HTTPS)) {
            return url;
        }
        if (HttpsParser.needsConvert(host)) {
            return url.replaceFirst(HTTP, HTTPS);
        }
        return url;
    }

    public static String convertToHttp(String url) {
        if (url == null || url.isEmpty() || !url.startsWith(HTTPS)) {
            return url;
        }
        String host = HttpsParser.getHost(url);
        if (host == null || host.isEmpty() || host.startsWith(HTTP)) {
            return url;
        }
        if (HttpsParser.needsConvert(host)) {
            return url.replaceFirst(HTTPS, HTTP);
        }
        return url;
    }

    public static Map<String, Integer> getHostMap() {
        if (hostMap == null) {
            hostMap = new ConcurrentHashMap<String, Integer>();
        }
        return hostMap;
    }
}

