package tv.athena.live.component.business.roominfo;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;

import com.yy.liveplatform.proto.nano.LpfLiveinfo;
import com.yy.liveplatform.proto.nano.LpfLiveinterconnect;

import java.util.Map;

import tv.athena.live.api.IDataCallback;
import tv.athena.live.api.roominfo.RoomInfoApi;
import tv.athena.live.api.roominfo.RoomInfoWrapper;
import tv.athena.live.base.arch.IComponentApi;

/**
 * @author : liaojidong
 * @e-mail : liaojidong@joyy.sg
 * @date : 2019/8/28 10:42
 * @desc :
 */
public class RoomInfoApiImpl implements RoomInfoApi {
    private RoomInfoComponent mComponent;

    public RoomInfoApiImpl(RoomInfoComponent component) {
        this.mComponent = component;
    }

    @Override
    public void addRoomInfoListener(RoomInfoListener listener) {
        if (mComponent == null || mComponent.getViewModel() == null) {
            return;
        }
        mComponent.getViewModel().addRoomInfoListener(listener);
    }

    @Override
    public void removeRoomInfoListener(RoomInfoListener listener) {
        if (mComponent == null || mComponent.getViewModel() == null) {
            return;
        }
        mComponent.getViewModel().removeRoomInfoListener(listener);
    }

    @Override
    public void getLiveRoomInfo(long sid) {
        if (mComponent == null || mComponent.getViewModel() == null) {
            return;
        }
        mComponent.getViewModel().getLiveRoomInfo(sid);
    }

    @Override
    public void getLiveRoomInfoByUid(long uid, int liveBzType,
                                     IDataCallback<LpfLiveinfo.LiveInfo> callback) {
        if (mComponent == null || mComponent.getViewModel() == null) {
            return;
        }
        mComponent.getViewModel().getLiveRoomInfoByUid(uid, liveBzType, callback);
    }

    @Override
    public Map<Integer, LpfLiveinterconnect.LiveInterconnectInfo> getMicInfos() {
        return mComponent.getViewModel().getMicInfos();
    }

    @Override
    public LpfLiveinterconnect.LiveInterconnectInfo getMicInfo(int position) {
        return mComponent.getViewModel().getMicInfo(position);
    }

    @Override
    public void observeLiveInfo(LifecycleOwner owner, Observer<LpfLiveinfo.LiveInfo> observer) {
        mComponent.getViewModel().getMLiveInfo().observe(owner, observer);
    }

    @Override
    public LpfLiveinfo.LiveInfo getLiveInfo() {
        return mComponent.getViewModel().getMLiveInfo().getValue();
    }

    @Override
    public Class<? extends IComponentApi> getApiKey() {
        return RoomInfoApi.class;
    }

    @Override
    public RoomInfoWrapper getRoomInfoWrapper() {
        return mComponent.getViewModel().getRoomInfoWrapper();
    }

    @Override
    public Boolean getLiveStatusByUid(Long uid) {
        return mComponent.getViewModel().getLiveStatusByUid(uid);
    }
}
