package tv.athena.live.component.business.report.cache;

import java.util.LinkedList;
import java.util.ListIterator;

public class UserCachedAudio {
    private int mCurCachedSize;
    private LinkedList<AudioCacheFrame> mDataList = new LinkedList<>();
    private static final int MAX_CHCHED_SIZE = 1024 * 1024;
    private long mCurCachedDuration;

    public UserCachedAudio() {
    }

    public synchronized void addData(byte[] data, long endTime, long duration) {
        if (data != null && data.length > 0) {
            AudioCacheFrame frame = AudioCacheFrame.obtain(data, endTime, duration);
            mDataList.addLast(frame);
            mCurCachedSize += data.length;
            mCurCachedDuration += duration;
            AudioCacheConfig.mCurCachedSize += data.length;
        }
    }

    public synchronized void discardExpiredData(long expiredTime) {
        do {
            AudioCacheFrame frame = mDataList.peekFirst();
            if (null == frame) {
                return;
            }

            if (frame.mEndTime > expiredTime) {
                return;
            }

            discardFirstFrame();
        } while (true);
    }

    public synchronized byte[] getCachedAudio(long expiredTime) {
        if (mDataList.isEmpty() || mCurCachedDuration < 1000) { // 小于1s的音频不上传,上座时间极短的用户音频没有意义,不上传
            return null;
        }

        int capbility = mCurCachedSize;
        if (capbility > MAX_CHCHED_SIZE) {
            capbility = MAX_CHCHED_SIZE;
        }

        byte[] byteBuf = new byte[capbility];
        int storedSize = 0;
        ListIterator<AudioCacheFrame> it = mDataList.listIterator();
        while (it.hasNext()) {
            AudioCacheFrame frame = it.next();
            if (frame != null && frame.mEndTime > expiredTime) { // 在时长范围内
                byte[] data = frame.mData;
                if (data != null && data.length > 0) {
                    // 数据超过容量,结束
                    if (byteBuf.length - storedSize < data.length) {
                        break;
                    }

                    System.arraycopy(data, 0, byteBuf, storedSize, data.length);
                    storedSize += data.length;
                }
            }
        }

        if (0 == storedSize) {
            return null;
        }

        // 还有容量剩余,那么返回实际的数据
        if (storedSize < byteBuf.length) {
            byte[] actualBuf = new byte[storedSize];
            System.arraycopy(byteBuf, 0, actualBuf, 0, storedSize);
            return actualBuf;
        }

        return byteBuf;
    }

    private synchronized void discardFirstFrame() {
        AudioCacheFrame frame = mDataList.removeFirst();
        if (frame != null) {
            if (frame.mData != null) {
                mCurCachedSize -= frame.mData.length;
                AudioCacheConfig.mCurCachedSize -= frame.mData.length;
            }

            mCurCachedDuration -= frame.mDuration;
            frame.recycle();
        }
    }
}
