package tv.athena.live.component.business.report.cache;

import android.text.TextUtils;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

import tv.athena.live.utils.ALog;

public enum AudioCacheService {
    INSTANCE;

    private HashMap<String, RoomCachedAudio> mAudioData = new HashMap<>();
    private static final String TAG = "AudioCacheService";
    private final AtomicInteger mLogAtomicInteger = new AtomicInteger();

    public synchronized void cacheAudioData(String roomId, Long uid, byte[] audioData, long duration) {
        if (mLogAtomicInteger.incrementAndGet() >= 500) {
            mLogAtomicInteger.set(0);
            ALog.i(AudioCacheConfig.TAG, "cacheAudioData roomId: " + roomId
                + ", uid: " + uid + ", duration: " + duration);
        }

        // 退出频道时先置空了频道id,但还未退出完成,此时还会返回数据,但是roomId为null,因此要判空
        if (TextUtils.isEmpty(roomId)) {
            return;
        }

        RoomCachedAudio roomAudio = mAudioData.get(roomId);
        if (null == roomAudio) {
            roomAudio = new RoomCachedAudio();
            mAudioData.put(roomId, roomAudio);
            //ALog.i(TAG, "cache room " + roomId);
        }

        roomAudio.cacheAudioData(uid, audioData, duration);
        //ALog.i(AudioCacheConfig.TAG, "after cache, cached size: " + AudioCacheConfig.mCurCachedSize);
    }

    public synchronized byte[] getCachedUserAudio(String roomId, long uid, long expiredTime) {
        RoomCachedAudio roomAudio = mAudioData.get(roomId);
        if (roomAudio != null) {
            byte[] cachedAudio = roomAudio.getUserCachedAudio(uid, expiredTime);
            ALog.i(AudioCacheConfig.TAG, "after getusercache, cached size: " + AudioCacheConfig.mCurCachedSize);
            return cachedAudio;
        }
        return null;
    }

    public synchronized void clearRoomCache(String roomId) {
        ALog.i(AudioCacheConfig.TAG, "clear room cahce, roomId: " + roomId);
        RoomCachedAudio roomAudio = mAudioData.remove(roomId);
        if (roomAudio != null) {
            roomAudio.reset();
        }
    }

    public synchronized HashMap<Long, byte[]> getRoomCachedAudio(String roomId, long expiredTime) {
        RoomCachedAudio roomAudio = mAudioData.get(roomId);
        if (roomAudio != null) {
            HashMap<Long, byte[]> cachedAudio = roomAudio.getCachedAudio(expiredTime);
            ALog.i(AudioCacheConfig.TAG, "after getroomcache, cached size: " + AudioCacheConfig.mCurCachedSize);
            return cachedAudio;
        }
        return null;
    }

}
