package tv.athena.live.component.business.report.cache;

public class AudioCacheFrame {
    public byte[] mData;
    public long mEndTime;
    public long mDuration;

    private static final Object sPoolSync = new Object();
    private static AudioCacheFrame sPool;
    private static int sPoolSize = 0;
    private AudioCacheFrame next;

    private static final int MAX_POOL_SIZE = 10;    // 如果8个用户在座位上,不间断说话,每新增一个结点,会淘汰一个结点,并且一次只回调一个用户

    public static AudioCacheFrame obtain() {
        synchronized (sPoolSync) {
            if (sPool != null) {
                AudioCacheFrame m = sPool;
                sPool = m.next;
                m.next = null;
                sPoolSize--;
                return m;
            }
        }
        return new AudioCacheFrame();
    }

    public static AudioCacheFrame obtain(byte[] data, long endTime, long duration) {
        AudioCacheFrame frame = obtain();
        frame.mData = data;
        frame.mEndTime = endTime;
        frame.mDuration = duration;
        return frame;
    }

    public void recycle() {
        mData = null;
        mEndTime = 0;
        mDuration = 0;

        synchronized (sPoolSync) {
            if (sPoolSize < MAX_POOL_SIZE) {
                next = sPool;
                sPool = this;
                sPoolSize++;
            }
        }
    }
}
