package tv.athena.live.component.business.broadcasting

import android.os.Handler
import android.os.Looper
import android.support.v4.util.ArrayMap
import android.view.ViewGroup
import com.thunder.livesdk.video.ThunderPreviewView
import tv.athena.live.base.arch.IComponentView
import tv.athena.live.base.manager.ComponentContext
import tv.athena.live.basesdk.thunderblotwrapper.ThunderHandle
import tv.athena.live.utils.ALog
import tv.athena.live.utils.ThreadUtil

/**
 *    create by chenhaofeng 2019-08-13
 *
 *
 */
class BroadcastView : IComponentView<BroadcastViewModel> {
    private val TAG = "BroadcastView"
    private var mContext: ComponentContext? = null
    private var mBroadcastComponent: BroadcastComponent? = null
    private var model: BroadcastViewModel? = null
    private var mPreviewContainerView: ViewGroup? = null
    private var mThunderPreviewView: ThunderPreviewView? = null
    private var mThunderBlotProxy: ThunderHandle? = null
    private val mHandler: Handler by lazy {
        Handler(Looper.getMainLooper())
    }

    companion object {
        const val BROADCAST_PREVIEW = "broadcast_preview"
    }

    override fun onInitView(viewResId: ArrayMap<String, Int>?) {
        val previewContainerId = viewResId?.get(BROADCAST_PREVIEW)
        if (!idIsValid(previewContainerId)) {
            ALog.i(TAG, "onInitView previewContainerId not valid")
            return
        }
        mPreviewContainerView = mContext!!.activity!!.findViewById(previewContainerId!!)
    }

    override fun onBindViewModel(viewModel: BroadcastViewModel?) {
        this.model = viewModel
    }

    fun setComponent(component: BroadcastComponent) {
        mBroadcastComponent = component
        mContext = mBroadcastComponent!!.componentContext
        this.mThunderBlotProxy = mContext?.thunderHandle
    }

    /**
     * 判断 id 是否合法
     * @return boolean false 为不合法
     */
    private fun idIsValid(id: Int?): Boolean {
        id?.let {
            return it > 0
        }
        return false
    }

    fun setPreviewZOrderOnTop(onTop: Boolean) {
        mThunderPreviewView?.let {
            it.surfaceView?.setZOrderOnTop(onTop)
            //避免SurfaceView上方UI被遮挡
            it.surfaceView?.setZOrderMediaOverlay(onTop)
        }
    }

    fun switchLocalVideoContainer(viewGroup: ViewGroup?) {
        val uid = mContext?.commonViewModel?.myUid.toString()
        ALog.i(TAG, "switchLocalVideoContainer uid = $uid [viewgroup : $viewGroup]")
        if (mThunderPreviewView == null) {
            ALog.i(TAG, "Invalid preview")
            return
        }

        mThunderPreviewView?.parent?.let {
            (it as ViewGroup).removeView(mThunderPreviewView)
        }
        mPreviewContainerView?.removeAllViews()

        viewGroup?.removeAllViews()
        mPreviewContainerView = viewGroup
        mPreviewContainerView?.addView(mThunderPreviewView,
            ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
    }

    fun removeAllView() {
        if (!ThreadUtil.isMainThread()) {
            mHandler.post { removeAllView() }
            return
        }
        mPreviewContainerView?.removeAllViews()
    }

    fun onDestroy() {
    }
}