package tv.athena.live.component.business.activitybar.webview.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

import tv.athena.live.utils.ALog;
import tv.athena.util.FP;
import tv.athena.util.encode.Base64Utils;

public class WebViewUtils {
    public static String handleImageToBase64JsonStr(String[] clipPaths) {
        if (clipPaths != null && clipPaths.length > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            JSONObject jsonObject;
            for (int i = 0; i < clipPaths.length; i++) {
                jsonObject = handleImageToBase64(clipPaths[i], 1280, 720);
                if (jsonObject != null) {
                    bitmapJsonArray.put(jsonObject);
                }
            }
            if (bitmapJsonArray.length() > 0) {
                ALog.i("handleImageToBase64JsonStr",
                    "[handleImageToBase64JsonStr].imgSizes=" + bitmapJsonArray.length());
                return bitmapJsonArray.toString();
            }
        }
        return "";
    }

    public static String handleImageToBase64JsonStr(List<String> clipPaths) {
        return handleImageToBase64JsonStrWithCompress(clipPaths, 1280, 720);
    }

    public static String handleImageToBase64JsonStrWithCompress(List<String> clipPaths, int reqWidth, int reqHeight) {
        if (clipPaths != null && clipPaths.size() > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            JSONObject jsonObject;
            for (int i = 0; i < clipPaths.size(); i++) {
                jsonObject = handleImageToBase64(clipPaths.get(i), reqWidth, reqHeight);
                if (jsonObject != null) {
                    bitmapJsonArray.put(jsonObject);
                }
            }
            if (bitmapJsonArray.length() > 0) {
                ALog.i("handleImageToBase64JsonStr",
                    "[handleImageToBase64JsonStr].imgSizes=" + bitmapJsonArray.length());
                return bitmapJsonArray.toString();
            }
        }
        return "";
    }

    public static JSONObject handleImageToBase64(String imgPath, int reqWidth, int reqHeight) {
        if (FP.empty(imgPath)) {
            ALog.w("handleImageToBase64", "[handleImageToBase64].imgPath is null");
            return null;
        }

        JSONObject bitmapJsonObject = null;
        ByteArrayOutputStream baos = null;
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            // 获取这个图片的宽和高，注意此处的bitmap为null
            bitmap = BitmapFactory.decodeFile(imgPath, options);
            options.inJustDecodeBounds = false;
//            options.inSampleSize = ImageUtil.calculateInSampleSize(options, reqWidth, reqHeight);
            ALog.i("handleImageToBase64",
                "[handleImageToBase64].Img origin  w=" + options.outWidth + ",h=" + options.outHeight + ",reqw=" +
                    reqWidth + ",reqh=" + reqHeight + ",simple=" + options.inSampleSize);
            baos = new ByteArrayOutputStream();
            bitmap = BitmapFactory.decodeFile(imgPath, options);
            int pos = imgPath.lastIndexOf(".");
            String suffix = null;
            if (pos + 1 < imgPath.length()) {
                suffix = imgPath.substring(pos + 1, imgPath.length());
            }
            if (!FP.empty(suffix) && (suffix.equalsIgnoreCase("jpg") || suffix.equalsIgnoreCase("jpeg"))) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 80, baos);
            } else {
                bitmap.compress(Bitmap.CompressFormat.PNG, 80, baos);
            }
            String base64Img = Base64Utils.encodeToString(baos.toByteArray(), Base64Utils.NO_WRAP);
            ALog.i("handleImageToBase64",
                "[handleImageToBase64].Img now w=" + options.outWidth + ",h=" + options.outHeight +
                    ",inSampleSize=" + options.inSampleSize + ",base64Img.size=" + base64Img.length() +
                    ",base64Img=" + base64Img.substring(0, 50));
            bitmapJsonObject = new JSONObject();
            bitmapJsonObject.put("thumbnail", base64Img);
            bitmapJsonObject.put("localFileName", imgPath);
            baos.close();
            bitmap.recycle();
            bitmap = null;
            baos = null;
        } catch (Throwable t) {
            if (baos != null) {
                try {
                    baos.flush();
                    baos.close();
                } catch (IOException e) {
                    ALog.e("handleImageToBase64", "[handleImageToBase64].IOException=", e);
                }
            }

            if (bitmap != null) {
                bitmap.recycle();
            }

            ALog.e("handleImageToBase64", "[handleImageToBase64].e=" + t + ",imgs=" + imgPath, t);
        }
        return bitmapJsonObject;
    }

    public static JSONObject handleImgThumbnailToBase64(String imgPath) {
        if (FP.empty(imgPath)) {
            ALog.w("handleImgThumbnailToBase64", "[ReturnBase64ImgToWeb].imgPath is null");
            return null;
        }

        JSONObject bitmapJsonObject = null;
        ByteArrayOutputStream baos = null;
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            // 获取这个图片的宽和高，注意此处的bitmap为null
            bitmap = BitmapFactory.decodeFile(imgPath, options);
            options.inJustDecodeBounds = false;
            ALog.i("handleImgThumbnailToBase64",
                "[ReturnBase64ImgToWeb].Img origin  w=" + options.outWidth + ",h=" + options.outHeight);
            int beWidth = options.outWidth / 512;
            int beHeight = options.outHeight / 512;
            int be = ((beWidth < beHeight) ? beWidth : beHeight);
            if (be <= 0) {
                be = 1;
            }
            options.inSampleSize = be;
            baos = new ByteArrayOutputStream();
            bitmap = BitmapFactory.decodeFile(imgPath, options);
            if (imgPath.endsWith("jpg") || imgPath.endsWith("jpeg")) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, baos);
            } else {
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos);
            }
            String base64Img = Base64Utils.encodeToString(baos.toByteArray(), Base64Utils.NO_WRAP);
            ALog.i("handleImgThumbnailToBase64",
                "[ReturnBase64ImgToWeb].Img now w=" + options.outWidth + ",h=" + options.outHeight +
                    ",inSampleSize=" + options.inSampleSize + ",base64Img.size=" + base64Img.length() +
                    ",base64Img=" + base64Img.substring(0, 50));
            bitmapJsonObject = new JSONObject();
            bitmapJsonObject.put("thumbnail", base64Img);
            bitmapJsonObject.put("localFileName", imgPath);
            baos.close();
            bitmap.recycle();
            bitmap = null;
            baos = null;
        } catch (Throwable t) {
            if (baos != null) {
                try {
                    baos.flush();
                    baos.close();
                } catch (IOException e) {
                    ALog.e("handleThumbnailRetToWeb", "[handleThumbnailRetToWeb].IOException=", e);
                }
            }

            if (bitmap != null) {
                bitmap.recycle();
            }

            ALog.e("handleThumbnailRetToWeb", "[handleThumbnailRetToWeb].e=" + t + ",imgs=" + imgPath, t);
        }

        return bitmapJsonObject;
    }
}
