package tv.athena.live.component.business.activitybar.webview;

import android.text.TextUtils;

import java.util.Iterator;
import java.util.Map;

import tv.athena.live.utils.ALog;

/**
 * create by qiushunming
 * 2019/3/19
 */
public class WebViewUrlCommonParams {
    private static final String TAG = "WebViewUrlCommonParams";

    public static String addCommonParams(String url, Map<String, String> params) {
        if (TextUtils.isEmpty(url)) {
            return "";
        }
        if (params == null || params.size() == 0) {
            return url;
        }
        ALog.i(TAG, "webview input url:" + url);
        Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (entry != null) {
                String key = entry.getKey();
                String value = entry.getValue();
                url = UrlParser.addParams(url, key, value);
            }
        }
        ALog.i(TAG, "webview final url:" + url);
        return url;
    }


}
