package tv.athena.live.component.business.activitybar.utils;

import android.app.Activity;
import android.content.Context;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;

public class ActivityUtils {

    public final static String FUN_IF_ACTIVITYWINDOW_PRESENT = "ifActivityWindowPresent";
    public final static String ACTIVITY_SERVICE_NAME = "lpfActivity";
    public final static String ActivityWindowListBroadcast = "activityWindowListBroadcast";
    public final static String ActivityDataBroadcast = "activityDataBroadcast";
    public final static int NO_SET = -2;

    public static String getSimCountryCode(Context context) {
        if (context == null) {
            return null;
        }
        TelephonyManager telephonyManager = (TelephonyManager)
            context.getSystemService(Context.TELEPHONY_SERVICE);
        String simCountryIso = telephonyManager.getSimCountryIso();
        if (!TextUtils.isEmpty(simCountryIso)) {
            return simCountryIso.toUpperCase();
        }
        return null;
    }

    public static int getScreenHeight(Activity context) {
        DisplayMetrics metrics = new DisplayMetrics();
        context.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics.heightPixels;
    }

}
