package tv.athena.live.component.business.activitybar.repository;

import com.yy.liveplatform.proto.nano.LpfActivity;

import tv.athena.live.component.business.activitybar.utils.ActivityUtils;
import tv.athena.live.utils.ServiceUtils;
import tv.athena.service.api.IMessageCallback;

public class ActivityBarServiceImpl implements IActivityBarService {

    @Override
    public void queryActWindow(long sid, boolean isAnchor,
                               IMessageCallback<LpfActivity.IfActivityWindowPresentResp> call) {
        LpfActivity.IfActivityWindowPresentReq req = new LpfActivity.IfActivityWindowPresentReq();
        req.anchorFlag = isAnchor;
        req.sid = sid;
        ServiceUtils.ServiceReq svcReq = new ServiceUtils.ServiceReq();
        svcReq.mFunctionName = ActivityUtils.FUN_IF_ACTIVITYWINDOW_PRESENT;
        svcReq.mServerName = ActivityUtils.ACTIVITY_SERVICE_NAME;
        svcReq.mReqParam = req;
        ServiceUtils.send(svcReq, call);
    }


}
