package tv.athena.live.component.business.activitybar;

import android.app.Activity;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;

import tv.athena.live.api.activitybar.ActivityBarApi;
import tv.athena.live.api.activitybar.bean.EntryData;
import tv.athena.live.api.activitybar.bean.WebViewFeature;
import tv.athena.live.api.activitybar.service.IJsApiModule;
import tv.athena.live.base.arch.IComponentView;
import tv.athena.live.base.manager.ComponentContext;
import tv.athena.live.api.activitybar.bean.ActivityBarConfig;
import tv.athena.live.api.activitybar.service.IWebViewUIClient;
import tv.athena.live.utils.ALog;
import tv.athena.live.component.business.activitybar.webview.WebViewUrlCommonParams;
import tv.athena.live.component.business.activitybar.webview.fragment.WebViewDialogFragment;
import tv.athena.live.component.business.activitybar.webview.fragment.WebViewFragment;
import tv.athena.live.component.business.activitybar.webview.jsapi.JsSupportWebApiAdapter;
import tv.athena.util.FP;

/**
 * @author baiting
 */
class ActivityBarView implements IComponentView<ActivityBarViewModel> {

    private static final String TAG = "ActivityBarView";
    private ActivityBarViewModel viewModel;
    private ComponentContext context;
    private int resId = ERROR_ID;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private static final int ERROR_ID = -100;
    private ActivityBarConfig config;
    private static final String DIALOG = "WebViewDialogFragment";
    private static final String ACTIVITY = "activityBar";

    public ActivityBarView() {

    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }

    @Override
    public void onInitView(ArrayMap<String, Integer> viewResId) {
        if (viewResId == null || context == null) {
            return;
        }

        Integer id = viewResId.get(ActivityBarApi.ACTIVITY_BAR_LAYOUT);
        setId(id);
    }

    private boolean valid(Integer resId) {
        if (resId == null || resId <= 0) {
            return false;
        }
        View view = context.getActivity().findViewById(resId);
        if (view != null && view instanceof ViewGroup) {
            return true;
        }
        return false;
    }

    public void setId(Integer id) {
        if (valid(id)) {
            this.resId = id;
        }
    }

    private String getUserName() {
        /*String nickName = context.getCommonViewModel().getOwnerNickName();
        if (!TextUtils.isEmpty(nickName)) {
            return nickName;
        }*/
        Long uid = context.getCommonViewModel().getMyUid();
        if (uid == null) {
            return "";
        } else {
            return String.valueOf(uid);
        }
    }

    public boolean isReady() {
        return resId != ERROR_ID;
    }

    public void showActivity(ActivityBarConfig config, String url, EntryData data) {
        this.config = config;
        final View mAttachedView = context.getActivity().findViewById(resId);
        mAttachedView.setVisibility(View.INVISIBLE);

        WebViewFeature feature = new WebViewFeature(
            WebViewFeature.FEATURE_SUPPORT_JS
                | WebViewFeature.FEATURE_ENABLE_CACHE |
                WebViewFeature.FEATURE_IS_TRAN);
        if (config != null) {
            url = WebViewUrlCommonParams.addCommonParams(url, config.getUrlCommonParams());
        }
        WebViewFragment actEntryFragment = WebViewFragment.newInstance(
            context.getActivity().getApplication(), url, feature);
        actEntryFragment.setActivityBarConfig(config);
        actEntryFragment.setIJsSupportWebApi(new JsSupportWebApiAdapter() {

            @Override
            public Activity getActivity() {
                return context.getActivity();
            }

            @Override
            public void showPopupWebView(String url, String configUIJson) {
                ALog.i("JavaScriptInterface",
                    "ActivityBarView, showPopupWebView url=" + url);
                mHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        showPopView(url, configUIJson);
                    }
                });
            }

            @Override
            public void closePopupWebView() {
                mHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        closePopView();
                    }
                });
            }

            @Override
            public EntryData getEntryData() {
                return data;
            }

            @Override
            public long getSid() {
                return context.getCommonViewModel().getSid();
            }

            @Override
            public String getOwnerName() {
                return getUserName();
            }

            @Override
            public void loadJavascript(String json) {
                mHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        loadJavaScript(json);
                    }
                });
            }

            @Override
            public long getOwnerUid() {
                return context.getCommonViewModel().getMyUid();
            }
        });
        // 活动入口和活动内容的桥梁，js通过调用他实现活动内容弹出
        FragmentTransaction transaction = context.getActivity().getSupportFragmentManager()
            .beginTransaction();
        transaction.replace(resId, actEntryFragment, ACTIVITY);
        transaction.commitAllowingStateLoss();

        actEntryFragment.setWebViewUIClient(new IWebViewUIClient() {
            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {

            }

            @Override
            public void onReceivedTitle(WebView view, String title) {

            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return false;
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                // 有时候会出现黑屏，晚点打开效果好很多
                mAttachedView.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (mAttachedView != null) {
                            mAttachedView.setVisibility(View.VISIBLE);
                        }
                    }
                }, 400);
                actEntryFragment.setWebViewUIClient(null);
            }
        });
    }

    @Override
    public void onBindViewModel(ActivityBarViewModel viewModel) {
        this.viewModel = viewModel;
    }

    private boolean isActivityFinish() {
        return context.getActivity() == null || context.getActivity().isDestroyed()
            || context.getActivity().isFinishing();
    }

    /**
     * 弹出活动框s
     *
     * @param url
     * @param configUIJson ui配置json，格式如下：
     *                     {
     *                     isFullScreen: boolean ,
     *                     isShowTitle: boolean ,
     *                     style: int ,
     *                     width: int ,
     *                     height: int ,
     *                     gravity: String
     *                     }
     */
    public void showPopView(String url, String configUIJson) {
        if (FP.empty(url) || isActivityFinish()) {
            return;
        }
        WebViewFeature feature = new WebViewFeature(WebViewFeature.FEATURE_SUPPORT_JS
            | WebViewFeature.FEATURE_ENABLE_CACHE
            | WebViewFeature.FEATURE_IS_TRAN
            | WebViewFeature.FEATURE_SHOW_LOADING
            | WebViewFeature.FEATURE_DISABLE_LONG_PRESS);

        if (config != null) {
            url = WebViewUrlCommonParams.addCommonParams(url, config.getUrlCommonParams());
        }
        WebViewDialogFragment webViewDialogFragment = WebViewDialogFragment
            .newInstance(url, feature.getFeatureValue(), configUIJson);
        try {
            webViewDialogFragment.setActivityBarConfig(config);
            webViewDialogFragment.setOwnerName(getUserName());
            if (context.getCommonViewModel().getSid() != null) {
                webViewDialogFragment.setSid(context.getCommonViewModel().getSid());
            }
            webViewDialogFragment.setOwnerUid(context.getCommonViewModel().getMyUid());
            if (!webViewDialogFragment.isAdded()) {
                webViewDialogFragment.show(context.getActivity().getSupportFragmentManager(),
                    DIALOG);
            } else {
                ALog.i(TAG, "DialogFragment is add");
            }
        } catch (IllegalStateException e) {
            ALog.d(TAG, "mWebViewDialogFragment.show error ", e);
        }
    }

    public void loadJavaScript(String data) {
        loadJavaScript(data, null);
    }

    public void loadJavaScript(String data, ValueCallback<String> callback) {
        if (isActivityFinish() || TextUtils.isEmpty(data)) {
            return;
        }
        WebViewFragment fragment = (WebViewFragment) context.getActivity()
            .getSupportFragmentManager()
            .findFragmentByTag(ACTIVITY);
        if (fragment != null) {
            if (callback == null) {
                callback = new ValueCallback<String>() {
                    @Override
                    public void onReceiveValue(String value) {
                        ALog.d(TAG, "onReceiveValue: " + value);
                    }
                };
            }
            fragment.loadJavaScript(data, callback);
        }
    }

    public void closePopView() {
        ALog.d(TAG, "close");
        if (isActivityFinish()) {
            return;
        }
        WebViewDialogFragment dialog = (WebViewDialogFragment) context.getActivity()
            .getSupportFragmentManager().findFragmentByTag(DIALOG);
        if (dialog != null && dialog.isAdded()) {
            dialog.dismissAllowingStateLoss();
        }
    }

    public void close() {
        closePopView();
        if (config != null && config.getIJsApiModules() != null) {
            for (IJsApiModule module : config.getIJsApiModules()) {
                if (module == null) {
                    continue;
                }
                module.release();
            }
            config.getIJsApiModules().clear();
        }
    }
}
