package tv.athena.live.component.business.report.repository;

import com.google.gson.Gson;
import com.yy.liveplatform.proto.nano.LpfAudit;

import java.util.UUID;

import tv.athena.live.basesdk.liveroom.LivePlatformSdk;
import tv.athena.live.utils.ServiceUtils;
import tv.athena.live.utils.IpUtils;
import tv.athena.service.api.IMessageCallback;

public class ReportRepository {
    private static final String SERVICE_NAME = "lpfAudit";
    private static final String FUN_AUDIT_REPORT_REQ = "auditReport";

    private Gson mGson = new Gson();

    /**
     * 举报
     *
     * @param sid          频道ID
     * @param reportedUid  被举报的用户ID
     * @param reportUid    举报者的用户ID
     * @param auditChannel 送审渠道
     * @param auditType    送审类型
     * @param content      送审的内容，一般为url或者是纯文本
     * @param audioDecode  是否音频需要解码
     * @param callback     请求回调
     */
    public void reportContent(long sid, long reportedUid, long reportUid,
                              int auditChannel, int auditType,
                              String content, int illegalType,
                              boolean audioDecode,
                              String ext,
                              IMessageCallback<LpfAudit.AuditReportResp> callback) {
        LpfAudit.AuditReportReq req = new LpfAudit.AuditReportReq();
        req.sid = sid;
        req.uid = reportedUid;
        req.reportUid = reportUid;
        req.auditChannel = auditChannel;
        req.content = content;
        req.serial = UUID.randomUUID().toString().replace("-", "");
        req.ssid = 0;
        req.auditType = auditType;
        req.ip = IpUtils.getIPAddress(LivePlatformSdk.getInstance().getApplication());
        req.appId = LivePlatformSdk.getInstance().getAppId() + "";
        req.reportType = illegalType;
        req.audioDecode = audioDecode;
        req.ext = ext;
        req.ext = mGson.toJson(req);

        ServiceUtils.ServiceReq svcReq = new ServiceUtils.ServiceReq();
        svcReq.mFunctionName = FUN_AUDIT_REPORT_REQ;
        svcReq.mServerName = SERVICE_NAME;
        svcReq.mReqParam = req;
        ServiceUtils.send(svcReq, callback);
    }
}
