package tv.athena.live.component.business.report

import android.content.Context

import tv.athena.live.api.report.ReportApi
import tv.athena.live.base.arch.IComponentApi

/**
 * @author : liaojidong
 * @e-mail : liaojidong@joyy.sg
 * @date : 2019/10/21 14:02
 * @desc :
 */
class ReportApiImpl(private val mComponent: ReportComponent?) : ReportApi {

    override fun getApiKey(): Class<out IComponentApi> {
        return ReportApi::class.java
    }

    override fun report(
        context: Context,
        reportedUid: Long,
        auditType: ReportApi.AuditType,
        businessIllegalType: Int,
        listener: ReportApi.OnReportListener,
        ext: String
    ) {
        if (this.mComponent != null && mComponent.viewModel != null) {
            this.mComponent.viewModel.report(context, reportedUid,
                businessIllegalType, auditType.value, listener, ext)
        }
    }
}
