package tv.athena.live.component.business.broadcasting.repository

import com.yy.liveplatform.proto.nano.LpfHeartbeat
import com.yy.liveplatform.proto.nano.LpfMedia
import tv.athena.live.utils.ServiceUtils
import tv.athena.service.api.IMessageCallback

/**
 *    create by chenhaofeng 2019-08-13
 *
 *
 */
object BroadcastRepository {
    const val FUNC_START_LIVE = "startLive"
    const val FUNC_LIVE_HEARTBEAT = "liveHeartbeat"
    const val FUNC_END_LIVE = "endLive"
    const val FUNC_MEDIA_SERVER_NAME = "lpfMedia"
    const val FUNC_GET_LIVE_TOKEN = "getLiveToken"
    const val FUNC_CHECK_LIVE_PERMISSION = "checkLivePermission"
    const val FUNC_REPORT_LIVE_PUBLISH_MEDIA_PARAM = "reportLivePublishMediaParam"
    const val FUNC_LPF_HEARTBEAT = "lpfHeartbeat"
    const val FUNC_STREAM_PUSH_CDN = "streamPushCDN"
    const val FUNC_CHANGE_LIVE_ROOM_TYPE = "changeLiveRoomType"
    const val FUNC_CHANGE_LIVE_MEDIA_TYPE = "updateMediaType"
    const val FUNC_STREAM_STOP_CDN = "streamStopCDN"

    //开播
    fun startLive(
        req: LpfMedia.StartLiveReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfMedia.StartLiveResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = FUNC_START_LIVE
        serviceReq.mServerName = FUNC_MEDIA_SERVER_NAME
        ServiceUtils.send(serviceReq, callback)
    }

    //停止开播
    fun endLiveReq(
        req: LpfMedia.EndLiveReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfMedia.EndLiveResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = FUNC_END_LIVE
        serviceReq.mServerName = FUNC_MEDIA_SERVER_NAME
        ServiceUtils.send(serviceReq, callback)
    }

    //开始发送直播心跳
    @Deprecated(message = "目前版本已经合并了心跳")
    fun startLiveHeartbeat(
        req: LpfMedia.LiveHeartbeatReq,
        callback: IMessageCallback<LpfMedia.LiveHeartbeatResp>
    ) {
        ping(req, callback)
    }

    @Deprecated(message = "目前版本已经合并了心跳")
    private fun ping(
        req: LpfMedia.LiveHeartbeatReq,
        callback: IMessageCallback<LpfMedia.LiveHeartbeatResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = FUNC_LIVE_HEARTBEAT
        serviceReq.mServerName = FUNC_MEDIA_SERVER_NAME
        ServiceUtils.send(serviceReq, callback)
    }

    fun checkLivePermission(
        req: LpfMedia.CheckLivePermissionReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfMedia.CheckLivePermissionResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = FUNC_CHECK_LIVE_PERMISSION
        serviceReq.mServerName = FUNC_MEDIA_SERVER_NAME
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     * 主播改变开播类型
     */
    fun changeLiveRoomType(
        req: LpfMedia.ChangeLiveRoomTypeReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfMedia.ChangeLiveRoomTypeResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = FUNC_CHANGE_LIVE_ROOM_TYPE
        serviceReq.mServerName = FUNC_MEDIA_SERVER_NAME
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     * 主播或上麦上嘉宾改变自己的媒体类型
     */
    fun changeLiveMediaType(
        req: LpfMedia.UpdateMediaTypeReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfMedia.UpdateMediaTypeResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = FUNC_CHANGE_LIVE_MEDIA_TYPE
        serviceReq.mServerName = FUNC_MEDIA_SERVER_NAME
        ServiceUtils.send(serviceReq, callback)
    }

    /***
     * 上报本地视频流的信息到中台业务后端，进行卡顿问题检测
     */
    fun reportLivePublishMediaParam(
        req: LpfHeartbeat.ReportLivePublishMediaParamReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfHeartbeat.ReportLivePublishMediaParamResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = FUNC_REPORT_LIVE_PUBLISH_MEDIA_PARAM
        serviceReq.mServerName = FUNC_LPF_HEARTBEAT
        ServiceUtils.sendNoRetry(serviceReq, callback)
    }

    /**
     * 上报请求推送cdn
     *
     */
    fun streamPushCDNReq(
        req: LpfMedia.StreamPushCDNReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfMedia.StreamPushCDNResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = FUNC_STREAM_PUSH_CDN
        serviceReq.mServerName = FUNC_MEDIA_SERVER_NAME
        ServiceUtils.sendNoRetry(serviceReq, callback)
    }

    fun streamStopPushCDNReq(
        req: LpfMedia.StreamStopCDNReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfMedia.StreamStopCDNResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = FUNC_STREAM_STOP_CDN
        serviceReq.mServerName = FUNC_MEDIA_SERVER_NAME
        ServiceUtils.sendNoRetry(serviceReq, callback)
    }
}