package tv.athena.live.component.business.activitybar.webview.fragment;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.JavascriptInterface;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;

import tv.athena.live.api.activitybar.bean.ActivityBarConfig;
import tv.athena.live.api.activitybar.bean.WebViewFeature;
import tv.athena.live.api.activitybar.service.ErrorCallBack;
import tv.athena.live.api.activitybar.service.IJsApiModule;
import tv.athena.live.api.activitybar.service.IJsSupportWebApi;
import tv.athena.live.api.activitybar.service.IWebViewFragment;
import tv.athena.live.api.activitybar.service.IWebViewUIClient;
import tv.athena.live.component.business.activitybar.webview.GlobalConfig;
import tv.athena.live.component.business.activitybar.webview.jsapi.JavaScriptInterface;
import tv.athena.live.component.business.activitybar.webview.model.ActivityCodes;
import tv.athena.live.component.business.activitybar.webview.model.PictureTakerActivityCodes;
import tv.athena.live.component.business.activitybar.webview.util.HttpsParser;
import tv.athena.live.component.business.activitybar.webview.util.ScheduledTask;
import tv.athena.live.component.business.activitybar.webview.util.WebViewUtils;
import tv.athena.live.utils.ALog;
import tv.athena.util.FP;

/**
 * Created by xudadade on 2019/3/26
 */
public class WebViewFragment extends Fragment implements IWebViewFragment {
    private static final String TAG = "WebViewFragment";

    public static final String LOAD_URL = "load_url";
    public static final String LOAD_DATA = "load_data";
    public static final String REQUEST_HEADER = "request_header";
    public static final String WEB_VIEW_FEATURE = "web_view_feature";

    private static final String WEB_VIEW_PULL = "WEB_VIEW_PULL";
    private static final String CURRENT_URL = "current_url";
    private static final String JS_OPERATION_YY_CLIENT = "YYClient";
    private static final String ANDROID_JS_INTERFACE_V_2 = "AndroidJSInterfaceV2";

    private static final String RESULT_TO_WEB =
        "javascript:try{window.unifiedResultToWeb('%s',JSON.parse('%s'));}catch(e){if(console)console.log(e)}";
    private static final String RESULT_TO_WEB_STRING = "javascript:try{window.unifiedResultToWeb('%s','{" +
        "\"code\":%s," +
        "\"message\":\"%s\"," +
        "\"data\":%s" +
        "}');}catch(e){if(console)console.log(e)}";

    private WebView mWebView;
    private final WebViewFeature mWebViewFeature;
    private String localData;

    private String mCurrentUrl;
    private View mProgressView;
    private View mContainer;
    private Bundle mBundle;
    private boolean mEnablePullRefresh = false;
    private boolean ignoreSslError = false;
    private boolean mIsShowLoading = true;
    private WebViewClient mWebViewClient;
    private WebChromeClient mChromeClient;
    private DownloadListener mDownloadListener;
    private IWebViewUIClient mIWebViewUIClient;
    private JavaScriptInterface mJsInterfaceV2;
    private IJsSupportWebApi mJsSupportWebbApi;
    private ValueCallback<Uri> mUploadFile;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private ActivityBarConfig config;
    private FrameLayout title;
    private String jsRegisterName = ANDROID_JS_INTERFACE_V_2;
    private String setUrl;

    class JsOperation {
        Activity mActivity;

        JsOperation(Activity activity) {
            mActivity = activity;
        }

        @JavascriptInterface
        public void finishActivity() {
            mActivity.finish();
        }
    }

    public static WebViewFragment newInstance(Context context, String url) {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(LOAD_URL, HttpsParser.convertToHttps(url));
        fragment.setArguments(bundle);
        return fragment;
    }

    public static WebViewFragment newInstance(String url) {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(LOAD_URL, HttpsParser.convertToHttps(url));
        fragment.setArguments(bundle);
        return fragment;
    }

    public static WebViewFragment newInstance() {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        fragment.setArguments(bundle);
        return fragment;
    }

    public static WebViewFragment newInstance(Context context, String url, WebViewFeature feature) {
        return newInstance(context, url, "", feature);
    }

    public static WebViewFragment newInstance(Context context, String url, String data, WebViewFeature feature) {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(LOAD_URL, HttpsParser.convertToHttps(url));
        bundle.putString(LOAD_DATA, data);
        bundle.putInt(WEB_VIEW_FEATURE, feature.getFeatureValue());
        fragment.setArguments(bundle);
        return fragment;
    }

    public static WebViewFragment newInstance(Context context, String url, WebViewFeature feature,
                                              HashMap<String, String> header) {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(LOAD_URL, HttpsParser.convertToHttps(url));
        bundle.putInt(WEB_VIEW_FEATURE, feature.getFeatureValue());
        if (header != null && !header.isEmpty()) {
            bundle.putSerializable(REQUEST_HEADER, header);
        }
        fragment.setArguments(bundle);
        return fragment;
    }

    public static WebViewFragment newInstance(Context context, String url, int feature) {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(LOAD_URL, HttpsParser.convertToHttps(url));
        bundle.putInt(WEB_VIEW_FEATURE, feature);
        fragment.setArguments(bundle);
        return fragment;
    }

    public WebViewFragment() {
        mWebViewFeature = new WebViewFeature();
    }

    public void setActivityBarConfig(ActivityBarConfig config) {
        this.config = config;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mBundle = getArguments();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = new View(container.getContext()); //inflater.inflate(R.layout.fragment_web,
        // container,
        // false);
        if (mWebView != null) {
            mWebView.destroy();
        }
        //title = view.findViewById(R.id.title);
        //mWebView = view.findViewById(R.id.ptr_webview);
        //mProgressView = view.findViewById(R.id.progress);

        int feature = mBundle.getInt(WEB_VIEW_FEATURE);
        if (feature != 0) {
            mWebViewFeature.setFeatureValue(feature);
        }

        mContainer = view;
        return view;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        if (savedInstanceState != null) {
            String url = savedInstanceState.getString(CURRENT_URL);
            mCurrentUrl = HttpsParser.convertToHttps(url);
        }
        applyWebViewFeature();
        setJsModuleApi();
        setWebViewClient();
        setWebChromeClient();
        showLoading();
    }

    public FrameLayout getTitleContainer() {
        return title;
    }

    @Override
    public void onResume() {
        mWebView.onResume();
        super.onResume();
        String data = mBundle.getString(LOAD_DATA);
        if (!FP.empty(data)) {
            loadDataInner(data);
            return;
        }
        if (!FP.empty(localData)) {
            loadDataInner(data);
            return;
        }
        String url;
        if (getCurrentUrl() != null) {
            url = getCurrentUrl();
        } else {
            url = mBundle.getString(LOAD_URL);
            if (TextUtils.isEmpty(url)) {
                url = setUrl;
            }
        }
        if (TextUtils.isEmpty(url) || url.equals(mCurrentUrl)) {
            return;
        }
        if (mBundle.containsKey(REQUEST_HEADER)) {
            HashMap<String, String> headers = (HashMap<String, String>) mBundle.getSerializable(REQUEST_HEADER);
            if (headers != null && !headers.isEmpty()) {
                loadUrl(url, headers);
            }
        } else {
            loadUrl(url);
        }
    }

    @Override
    public void onPause() {
        if (mWebView == null) {
            return;
        }
        super.onPause();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
            mWebView.onPause();
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(CURRENT_URL, mWebView.getUrl());
        outState.putBoolean(WEB_VIEW_PULL, mEnablePullRefresh);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == ActivityCodes.REQUEST_CODE_TAG_REFRESH) {
            loadUrl(mCurrentUrl);
            return;
        } else if (requestCode == ActivityCodes.REQUEST_CODE_TAG_REFRESHPART) {
            if (null != mWebView) {
                if (Build.VERSION.SDK_INT <= 18) {
                    mWebView.loadUrl("javascript:reshPart()");
                } else {
                    try { //修复山寨机崩溃，Report ID：#fbbe67f0-6a0c-3c9a-9ea8-10f77db9b6bd
                        mWebView.evaluateJavascript("javascript:reshPart()", null);
                    } catch (Exception e) {
                        ALog.e(TAG, "", e);
                        mWebView.loadUrl("javascript:reshPart()");
                    }
                }
            }
            return;
        }

        if (requestCode == ActivityCodes.REQUEST_WEB_CHOOSE_FILE) {
            Uri result = data == null || resultCode != Activity.RESULT_OK ? null : data.getData();

            if (this.mUploadFile != null) {
                this.mUploadFile.onReceiveValue(result);
            }
        }
        if (requestCode > ActivityCodes.REQUEST_CODE_TAG_MIN && requestCode < ActivityCodes.REQUEST_CODE_TAG_TASK_MAX) {
            handlePictureTaker(requestCode, resultCode, data);
        } else {
            handleWebActResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();

        if (mContainer != null && mContainer.getParent() instanceof ViewGroup) {
            ((ViewGroup) mContainer.getParent()).removeView(mContainer);
        }

        if (title != null) {
            title.removeAllViews();
        }
    }

    @Override
    public void onDestroy() {
        if (mIsShowLoading) {
            hideLoading();
        }

        if (mWebView != null) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
                mWebView.removeJavascriptInterface(JS_OPERATION_YY_CLIENT);
            }
            mWebView.setDownloadListener(null);
            //mWebView.setWebViewClient(null);
            //java.lang.Throwable: Error: WebView.destroy() called while still attached!
            final ViewGroup viewGroup = (ViewGroup) mWebView.getParent();
            if (viewGroup != null) {
                viewGroup.removeView(mWebView);
            }
            try {
                mWebView.stopLoading();
                mJsInterfaceV2.release();
                if (Build.VERSION.SDK_INT > Build.VERSION_CODES.HONEYCOMB) {
                    mWebView.removeJavascriptInterface(jsRegisterName);
                }
                mWebView.destroy();
            } catch (Throwable e) {
                ALog.e(TAG, "webview destroy error!!!", e);
            }
            mWebView = null;
        }

        // fix SDANDROID-3030,
        super.onDestroy();
    }

    @Override
    public WebView getWebView() {
        return mWebView;
    }

    @Override
    public Fragment getFragment() {
        return this;
    }

    @Override
    public void setWebViewUIClient(IWebViewUIClient client) {
        mIWebViewUIClient = client;
    }

    @Override
    public void setDownloadListener(DownloadListener listener) {
        mDownloadListener = listener;
    }

    @Override
    public void setLocalUrl(String data) {
        localData = data;
    }

    @Override
    public void setWebViewFeature(WebViewFeature mFeature) {
        if (mFeature == null || mWebViewFeature == null) {
            return;
        }
        int feature = mFeature.getFeatureValue();
        if (feature != 0) {
            mWebViewFeature.setFeatureValue(feature);
        }
    }

    @Override
    public void loadUrl(String url) {
        if (mWebView == null) {
            setUrl = url;
            return;
        }

        if (FP.empty(url)) {
            if (config != null && config.getErrorCallback() != null) {
                config.getErrorCallback().onError(ErrorCallBack.URL_EMPTY);
            }
            return;
        }

        url = HttpsParser.convertToHttps(url);
        loadUrlInner(url);
    }

    @Override
    public void loadUrl(String url, HashMap<String, String> headers) {
        if (mWebView == null) {
            return;
        }

        if (FP.empty(url)) {
            if (config != null && config.getErrorCallback() != null) {
                config.getErrorCallback().onError(ErrorCallBack.URL_EMPTY);
            }
            return;
        }

        url = HttpsParser.convertToHttps(url);
        loadUrlInner(url, headers);
    }

    @Override
    public void loadJavaScript(String javaScript, ValueCallback<String> resultCallback) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                if (mWebView != null) {
                    try { //修复山寨机崩溃，Report ID：#fbbe67f0-6a0c-3c9a-9ea8-10f77db9b6bd
                        mWebView.evaluateJavascript(javaScript, resultCallback);
                    } catch (Exception e) {
                        ALog.e(TAG, "", e);
                        mWebView.loadUrl(javaScript);
                    }
                }
            }
        });
    }

    @Override
    public void addJsApiModule(IJsApiModule module) {
        if (mJsInterfaceV2 != null) {
            mJsInterfaceV2.addApiModule(module);
        }
    }

    @SuppressLint("JavascriptInterface")
    @Override
    public void addJsInterface(Object object, String name) {
        if (mWebView == null) {
            return;
        }
        mWebView.addJavascriptInterface(object, name);
    }

    @Override
    public void showLoading() {
        boolean isSet = false;
        if (config != null && config.getIActivityBarUI() != null) {
            isSet = config.getIActivityBarUI().showLoadingDialog();
        }
        if (!isSet && mIsShowLoading) {
            mProgressView.setVisibility(View.VISIBLE);
        }

    }

    @Override
    public void hideLoading() {
        boolean isSet = false;
        if (config != null && config.getIActivityBarUI() != null) {
            isSet = config.getIActivityBarUI().hideDialog();
        }
        if (!isSet && mIsShowLoading) {
            mProgressView.setVisibility(View.GONE);
        }

    }

    @Override
    public void setIJsSupportWebApi(IJsSupportWebApi iJsSupportWebApi) {
        mJsSupportWebbApi = iJsSupportWebApi;
    }

    private void setJsModuleApi() {
        if (mWebView == null) {
            return;
        }
        mJsInterfaceV2 = new JavaScriptInterface(mWebView, mJsSupportWebbApi);
        if (config != null && config.getIJsApiModules() != null
            && config.getIJsApiModules().size() > 0) {
            for (IJsApiModule module : config.getIJsApiModules()) {
                if (module == null) {
                    continue;
                }
                mJsInterfaceV2.addApiModule(module);
            }
        }
        if (config != null && !TextUtils.isEmpty(config.getJsRegisterName())) {
            jsRegisterName = config.getJsRegisterName();
        }
        mWebView.addJavascriptInterface(mJsInterfaceV2, jsRegisterName);
    }

    protected void setWebChromeClient() {
        if (mWebView == null) {
            return;
        }
        if (mChromeClient == null) {
            mChromeClient = new WebChromeClient() {

                @Override
                public void onReceivedTitle(WebView view, String title) {
                    if (config != null && config.getIActivityBarUI() != null) {
                        config.getIActivityBarUI().onReceivedTitle(view, title);
                    }

                    if (mIWebViewUIClient != null) {
                        mIWebViewUIClient.onReceivedTitle(view, title);
                    }
                    super.onReceivedTitle(view, title);
                }

                // For Android  >= 3.0
                public void openFileChooser(ValueCallback valueCallback, String acceptType) {
                    mUploadFile = valueCallback;
                }

                //For Android  >= 4.1
                public void openFileChooser(ValueCallback<Uri> valueCallback, String acceptType, String capture) {
                    mUploadFile = valueCallback;
                }
            };
        }
        mWebView.setWebChromeClient(mChromeClient);
    }

    protected void setWebViewClient() {
        if (mWebView == null) {
            return;
        }
        if (mWebViewClient == null) {
            mWebViewClient = new WebViewClient() {
                @Override
                public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
                    ALog.w(TAG, "onReceivedSslError error=" + error);
                    if (ignoreSslError) {
                        handler.proceed();
                        return;
                    }
                    if (config != null && config.getErrorCallback() != null) {
                        config.getErrorCallback().onReceivedSslError(view, handler, error);
                    }
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    if (config != null && config.getIActivityBarUI() != null) {
                        config.getIActivityBarUI().onPageFinished(view, url);
                    }
                    if (mIWebViewUIClient != null) {
                        mIWebViewUIClient.onPageFinished(view, url);
                    }

                    super.onPageFinished(view, url);
                    if (mWebView != null) {
                        mWebView.getSettings().setBlockNetworkImage(false);
                    }

                    setDownLoadListener();
                    hideLoading();

                }

                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    boolean bHandler = false;
                    if (config != null && config.getIActivityBarUI() != null) {
                        bHandler = config.getIActivityBarUI().shouldOverrideUrlLoading(view, url);
                    }
                    if (bHandler) {
                        return true;
                    }

                    if (mIWebViewUIClient != null) {
                        bHandler = mIWebViewUIClient.shouldOverrideUrlLoading(view, url);
                    }
                    if (bHandler) {
                        return true;
                    }

                    if (!FP.empty(url) && url.startsWith("http")) {
                        mCurrentUrl = url;
                    }
                    if (null != view && !FP.empty(url)
                        && (url.startsWith("http://") || url.startsWith("https://"))) {
                        view.loadUrl(url);
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, url);
                }

                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    showLoading();
                    if (config != null && config.getIActivityBarUI() != null) {
                        config.getIActivityBarUI().onPageStarted(view, url, favicon);
                    }
                    if (mIWebViewUIClient != null) {
                        mIWebViewUIClient.onPageStarted(view, url, favicon);
                    }

                    super.onPageStarted(view, url, favicon);
                    if (url != null && !url.contains("file://")) {
                        mCurrentUrl = url;
                    }
                }

                @Override
                public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
                    if (event.getKeyCode() == KeyEvent.KEYCODE_BACK) {
                        return true;
                    }
                    return super.shouldOverrideKeyEvent(view, event);
                }

                @Override
                public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
                    applyWebViewFeature();

                    setJsModuleApi();
                    setWebViewClient();
                    setWebChromeClient();
                    mWebView.loadUrl(mCurrentUrl);

                    return true;
                }
            };
        }
        mWebView.setWebViewClient(mWebViewClient);
    }

    protected void setDownLoadListener() {
        if (mWebView == null) {
            return;
        }
        if (mDownloadListener == null) {
            mDownloadListener = new DownloadListener() {
                @Override
                public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype,
                                            long contentLength) {
                    ALog.i(TAG, "url=" + url);
                    ALog.i(TAG, "userAgent=" + userAgent);
                    ALog.i(TAG, "contentDisposition=" + contentDisposition);
                    ALog.i(TAG, "mimetype=" + mimetype);
                    ALog.i(TAG, "contentLength=" + contentLength);
                    Uri uri = Uri.parse(url);
                    Intent intent = new Intent(Intent.ACTION_VIEW, uri);
                    if (getActivity() != null) {
                        if (intent.resolveActivity(getActivity().getPackageManager()) != null) {
                            startActivity(intent);
                        } else {
                            ALog.i(TAG, "can not found activity by this intent:" + intent);
                            if (config != null && config.getErrorCallback() != null) {
                                config.getErrorCallback().onError(ErrorCallBack.DOWNLOAD_FAIL);
                            }
                        }
                    }
                }
            };
        }
        mWebView.setDownloadListener(mDownloadListener);
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void applyWebViewFeature() {
        if (null == mWebView) {
            ALog.w(TAG, "warnning: fail apply webview feature, target webview is null.");
            return;
        }

        mIsShowLoading = mWebViewFeature.isSupportFeature(WebViewFeature.FEATURE_SHOW_LOADING);

        //Transparent
        if (mWebViewFeature.isSupportFeature(WebViewFeature.FEATURE_IS_TRAN)) {
            mWebView.setBackgroundColor(0);
            if (mWebView.getBackground() != null) {
                mWebView.getBackground().setAlpha(0);
            }
        }

        //Js Support
        try {
            if (mWebViewFeature.isSupportFeature(WebViewFeature.FEATURE_SUPPORT_JS)) {
                mWebView.addJavascriptInterface(new JsOperation(getActivity()),
                    JS_OPERATION_YY_CLIENT);
                mWebView.getSettings().setJavaScriptEnabled(true);
            } else {
                mWebView.getSettings().setJavaScriptEnabled(false);
            }
        } catch (Throwable t) {
            ALog.e(TAG, "", t);
        }

        //Cache
        if (mWebViewFeature.isSupportFeature(WebViewFeature.FEATURE_ENABLE_CACHE)) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
                mWebView.getSettings().setCacheMode(WebSettings.LOAD_DEFAULT);
            } else {
                mWebView.getSettings().setCacheMode(WebSettings.LOAD_NORMAL);
            }
        } else {
            mWebView.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);
        }

        if (mWebViewFeature.isSupportFeature(WebViewFeature.FEATURE_CLEAR_FORM_DATA)) {
            mWebView.clearFormData();
        }
        if (mWebViewFeature.isSupportFeature(WebViewFeature.FEATURE_CLEAR_HISTORY)) {
            mWebView.clearHistory();
        }

        // 禁止长按弹出复制框
        if (mWebViewFeature.isSupportFeature(WebViewFeature.FEATURE_DISABLE_LONG_PRESS)) {
            if (mWebView instanceof View) {
                (mWebView).setOnLongClickListener(v -> true);
            }
        }

        mWebView.getSettings().setBuiltInZoomControls(false);
        mWebView.getSettings().setUseWideViewPort(true);
        mWebView.getSettings().setDomStorageEnabled(true);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            mWebView.getSettings().setMixedContentMode(android.webkit.WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }
        mWebView.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);

        //UserAgent
        if (!FP.empty(GlobalConfig.getUserAgentSuffix())) {
            String newUA = mWebView.getSettings().getUserAgentString() + " " + GlobalConfig.getUserAgentSuffix();
            mWebView.getSettings().setUserAgentString(newUA);
        }
    }

    private void loadUrlInner(String url) {
        if (mWebView == null) {
            return;
        }
        mCurrentUrl = url;
        mWebView.getSettings().setBlockNetworkImage(true);
        boolean isUrlNoChange = mWebView.getUrl() != null &&
            (mCurrentUrl.equals(mWebView.getUrl()) || mWebView.getUrl().equals(mCurrentUrl + "#/"));
        if (isUrlNoChange) {
            mWebView.reload();
        } else {
            mWebView.loadUrl(url);
        }
    }

    private void loadUrlInner(String url, HashMap<String, String> headers) {
        if (mWebView == null) {
            return;
        }
        mCurrentUrl = url;
        mWebView.getSettings().setBlockNetworkImage(true);
        boolean isUrlNoChange = mWebView.getUrl() != null &&
            (mCurrentUrl.equals(mWebView.getUrl()) || mWebView.getUrl().equals(mCurrentUrl + "#/"));
        if (isUrlNoChange) {
            mWebView.reload();
        } else {
            mWebView.loadUrl(url, headers);
        }
    }

    private void loadDataInner(String data) {
        if (mWebView == null) {
            return;
        }
        mWebView.getSettings().setBlockNetworkImage(true);
        mWebView.loadData(data, "text/html", "utf-8");
    }

    private String getCurrentUrl() {
        return mCurrentUrl;
    }

    private void handlePictureTaker(final int requestCode, int resultCode, Intent data) {
        if (mWebView == null) {
            return;
        }
        if (resultCode == Activity.RESULT_CANCELED || data == null) {
            String invokeStr = String.format(RESULT_TO_WEB_STRING, 0, 2, "", "[]");
            ALog.i(TAG, "[handlePictureTaker].[cancel]");
            mWebView.loadUrl(invokeStr);
        } else {
            final int type;
            final String[] uris;
            switch (requestCode) {
                case ActivityCodes.REQUEST_CODE_TAG_CAMERA_AS_PORTRAIT://拍照
                    uris = data.getStringArrayExtra("portrait_clip_key");
                    type = 1;
                    break;
                case ActivityCodes.REQUEST_CODE_TAG_GALLERY_AS_PORTRAIT://相册，单选
                    uris = new String[]{data.getStringExtra("portrait_clip_key")};
                    type = 2;
                    break;
                case ActivityCodes.REQUEST_CODE_TAG_GALLERY_MULTI_AS_PORTRAIT://相册,多选
                    uris = data.getStringArrayExtra("portrait_clip_key");
                    type = 3;
                    break;
                default:
                    uris = new String[]{};
                    type = 0;
            }
            //图片转base64
            ScheduledTask.getInstance().scheduledDelayed(() -> {
                final int code;
                final String param;
                if (FP.empty(uris)) {
                    param = "[]";
                    code = 2;
                } else {
                    param = WebViewUtils.handleImageToBase64JsonStr(uris);
                    code = 1;
                }
                if (mHandler != null) {
                    mHandler.post(() -> {
                        if (mWebView != null) {
                            String invokeStr = String.format(RESULT_TO_WEB_STRING, type, code, "", param);
                            ALog.i(TAG, "[handlePictureTaker].type=" + type + ",len=" + invokeStr.length());
                            mWebView.loadUrl(invokeStr);
                        }
                    });
                }
            }, 0);
        }
    }

    private void handleWebActResult(final int requestCode, int resultCode, final Intent data) {
        if (data != null && resultCode == Activity.RESULT_OK) {
            //异步线程处理图片
            ScheduledTask.getInstance().scheduledDelayed(() -> {
                final String param;
                final int type;
                switch (requestCode) {
                    case PictureTakerActivityCodes.REQUEST_CODE_CAMERA_AS_PORTRAIT_CLIP://带裁剪功能拍照
                        String[] cameraImgUrls = new String[]{data.getStringExtra(PictureTakerActivityCodes.CLIP_KEY)};
                        param = handleThumbnailRetToWeb(cameraImgUrls);
                        type = 5;
                        break;
                    case PictureTakerActivityCodes.REQUEST_CODE_GALLERY_AS_PORTRAIT_CLIP://带裁剪功能相册
                        String[] imgUrls = new String[]{data.getStringExtra(PictureTakerActivityCodes.CLIP_KEY)};
                        param = handleThumbnailRetToWeb(imgUrls);
                        type = 4;
                        break;
                    case PictureTakerActivityCodes.REQUEST_CODE_GALLERY_AS_PORTRAIT://相册
                        String[] urisImg = data.getStringArrayExtra(PictureTakerActivityCodes.CLIP_KEY);
                        param = handleThumbnailRetToWeb(urisImg);
                        type = 3;
                        break;
                    case PictureTakerActivityCodes.REQUEST_CODE_CAMERA_AS_PORTRAIT://拍照
                        String[] uris = data.getStringArrayExtra(PictureTakerActivityCodes.CLIP_KEY);
                        param = handleThumbnailRetToWeb(uris);
                        type = 2;
                        break;
                    default:
                        type = 0;
                        param = null;
                }

                if (mHandler != null) {
                    mHandler.post(() -> {
                        if (!FP.empty(param) && mWebView != null && type != 0) {
                            String invokeStr = String.format(RESULT_TO_WEB, type, param);
                            ALog.i(TAG, "[base64ImageToWeb].type=" + type + ",len=" + invokeStr.length());
                            mWebView.loadUrl(invokeStr);
                        }
                    });
                }
            }, 0);
        }
    }

    private String handleThumbnailRetToWeb(String[] clipPaths) {
        if (clipPaths != null && clipPaths.length > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            JSONObject jsonObject;
            for (int i = 0; i < clipPaths.length; i++) {
                jsonObject = WebViewUtils.handleImgThumbnailToBase64(clipPaths[i]);
                if (jsonObject != null) {
                    bitmapJsonArray.put(jsonObject);
                }
            }
            if (bitmapJsonArray.length() > 0) {
                ALog.i("handleThumbnailRetToWeb", "[ReturnBase64ImgToWeb].imgSizes=" + bitmapJsonArray.length());
                return bitmapJsonArray.toString();
            }
        }
        return null;
    }

    @Override
    public void onDetach() {
        super.onDetach();
    }
}
