/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.core.sly;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.annotation.MessageBinding;
import tv.athena.core.sly.SlyMessage;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002$%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\f\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ltv/athena/core/sly/SlyBridge;", "Landroid/os/Handler$Callback;", "()V", "TAG", "", "mIoHandler", "Landroid/os/Handler;", "mIoThread", "Landroid/os/HandlerThread;", "mLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "mMainHandler", "mMessageCenter", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "Ljava/util/HashMap;", "Ltv/athena/core/sly/SlyBridge$IMessageHandler;", "Ltv/athena/core/sly/SlyBridge$IMessage;", "Lkotlin/collections/HashMap;", "mSlyCenter", "", "existMessageBinding", "", "observer", "handleMessage", "msg", "Landroid/os/Message;", "register", "", "messageHandler", "sendMessage", "message", "Ltv/athena/core/sly/SlyMessage;", "subscribe", "unSubscribe", "unregister", "IMessage", "IMessageHandler", "core_release"})
public final class SlyBridge
implements Handler.Callback {
    private static final String TAG = "SlyBridge";
    private static final HandlerThread mIoThread;
    private static Handler mIoHandler;
    private static final Handler mMainHandler;
    private static final ConcurrentHashMap<Class<?>, HashMap<IMessageHandler, IMessage>> mMessageCenter;
    private static final ConcurrentHashMap<Object, IMessageHandler> mSlyCenter;
    private static final ReentrantReadWriteLock mLock;
    public static final SlyBridge INSTANCE;

    public boolean handleMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        return true;
    }

    public final void sendMessage(@NotNull SlyMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        mLock.readLock().lock();
        HashMap<IMessageHandler, IMessage> hashMap = mMessageCenter.get(message.getClass());
        if (hashMap != null) {
            Map $receiver$iv;
            Map map = $receiver$iv = (Map)hashMap;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Message m2;
                Map.Entry element$iv;
                Map.Entry map2 = element$iv = iterator.next();
                boolean sync = ((IMessage)map2.getValue()).getSync();
                boolean mainThread = ((IMessage)map2.getValue()).getMainThread();
                long delay = ((IMessage)map2.getValue()).getDelay();
                Message msg = new Message();
                msg.obj = message;
                if (sync) {
                    ((IMessageHandler)map2.getKey()).handlerMessage(msg);
                    continue;
                }
                if (mainThread) {
                    m2 = Message.obtain((Handler)mMainHandler, (Runnable)new Runnable(map2, msg){
                        final /* synthetic */ Map.Entry $map;
                        final /* synthetic */ Message $msg;

                        public final void run() {
                            ((IMessageHandler)this.$map.getKey()).handlerMessage(this.$msg);
                        }
                        {
                            this.$map = entry;
                            this.$msg = message;
                        }
                    });
                    if (delay > 0L) {
                        mMainHandler.sendMessageDelayed(m2, delay);
                        continue;
                    }
                    mMainHandler.sendMessage(m2);
                    continue;
                }
                m2 = Message.obtain((Handler)mIoHandler, (Runnable)new Runnable(map2, msg){
                    final /* synthetic */ Map.Entry $map;
                    final /* synthetic */ Message $msg;

                    public final void run() {
                        ((IMessageHandler)this.$map.getKey()).handlerMessage(this.$msg);
                    }
                    {
                        this.$map = entry;
                        this.$msg = message;
                    }
                });
                if (delay > 0L) {
                    mIoHandler.sendMessageDelayed(m2, delay);
                    continue;
                }
                mIoHandler.sendMessage(m2);
            }
        }
        mLock.readLock().unlock();
    }

    private final void register(IMessageHandler messageHandler) {
        mLock.writeLock().lock();
        Iterable $receiver$iv = messageHandler.messages();
        for (Object element$iv : $receiver$iv) {
            HashMap hashMap;
            HashMap it;
            IMessage msg = (IMessage)element$iv;
            HashMap hashMap2 = mMessageCenter.get(msg.getEvent());
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
            }
            HashMap hashMap3 = it = (hashMap = hashMap2);
            Intrinsics.checkExpressionValueIsNotNull(hashMap3, (String)"it");
            Map map = hashMap3;
            Object object = messageHandler;
            Object object2 = msg;
            map.put(object, object2);
            map = mMessageCenter;
            object = msg.getEvent();
            object2 = it;
            map.put(object, object2);
        }
        mLock.writeLock().unlock();
    }

    private final void unregister(IMessageHandler messageHandler) {
        mLock.writeLock().lock();
        Iterable $receiver$iv = messageHandler.messages();
        for (Object element$iv : $receiver$iv) {
            IMessage it = (IMessage)element$iv;
            HashMap<IMessageHandler, IMessage> hashMap = mMessageCenter.get(it.getEvent());
            if (hashMap == null) continue;
            hashMap.remove(messageHandler);
        }
        mLock.writeLock().unlock();
    }

    private final boolean existMessageBinding(Object observer) {
        boolean bl;
        block1: {
            Method[] methodArray = observer.getClass().getDeclaredMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"observer.javaClass.declaredMethods");
            for (Method element$iv : methodArray) {
                Method it = element$iv;
                if (!(it.getAnnotation(MessageBinding.class) != null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean subscribe(@NotNull Object observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        IMessageHandler slyBinder = mSlyCenter.get(observer);
        if (slyBinder != null || !this.existMessageBinding(observer)) {
            return false;
        }
        try {
            Constructor<?> constructor;
            String clazzName = observer.getClass().getCanonicalName() + "$$SlyBinder";
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> constructor2 = constructor = clazz.getDeclaredConstructor(observer.getClass(), SlyBridge.class);
            Intrinsics.checkExpressionValueIsNotNull(constructor2, (String)"constructor");
            constructor2.setAccessible(true);
            Object instance = constructor.newInstance(observer, this);
            if (!(instance instanceof IMessageHandler)) {
                return false;
            }
            Map map = mSlyCenter;
            Object obj = instance;
            map.put(observer, obj);
            this.register((IMessageHandler)instance);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)(observer + " subscribe sly fail, the reason is " + e.getMessage()));
            return false;
        }
        return true;
    }

    public final boolean unSubscribe(@NotNull Object observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        if (mSlyCenter.get(observer) != null) {
            IMessageHandler iMessageHandler = mSlyCenter.remove(observer);
            if (iMessageHandler == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)iMessageHandler, (String)"mSlyCenter.remove(observer)!!");
            this.unregister(iMessageHandler);
            return true;
        }
        return false;
    }

    private SlyBridge() {
    }

    static {
        SlyBridge slyBridge;
        INSTANCE = slyBridge = new SlyBridge();
        mIoThread = new HandlerThread("SlyBridgeIOThread");
        mMainHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)slyBridge);
        mMessageCenter = new ConcurrentHashMap();
        mSlyCenter = new ConcurrentHashMap();
        mLock = new ReentrantReadWriteLock(true);
        mIoThread.start();
        mIoHandler = new Handler(mIoThread.getLooper(), (Handler.Callback)slyBridge);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0010\u0018\u00002\u00020\u0001B/\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015\u00a8\u0006\u0018"}, d2={"Ltv/athena/core/sly/SlyBridge$IMessage;", "", "event", "Ljava/lang/Class;", "mainThread", "", "sync", "delay", "", "(Ljava/lang/Class;ZZJ)V", "getDelay", "()J", "setDelay", "(J)V", "getEvent", "()Ljava/lang/Class;", "setEvent", "(Ljava/lang/Class;)V", "getMainThread", "()Z", "setMainThread", "(Z)V", "getSync", "setSync", "core_release"})
    public static final class IMessage {
        @NotNull
        private Class<?> event;
        private boolean mainThread;
        private boolean sync;
        private long delay;

        @NotNull
        public final Class<?> getEvent() {
            return this.event;
        }

        public final void setEvent(@NotNull Class<?> clazz) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"<set-?>");
            this.event = clazz;
        }

        public final boolean getMainThread() {
            return this.mainThread;
        }

        public final void setMainThread(boolean bl) {
            this.mainThread = bl;
        }

        public final boolean getSync() {
            return this.sync;
        }

        public final void setSync(boolean bl) {
            this.sync = bl;
        }

        public final long getDelay() {
            return this.delay;
        }

        public final void setDelay(long l) {
            this.delay = l;
        }

        public IMessage(@NotNull Class<?> event, boolean mainThread, boolean sync, long delay) {
            Intrinsics.checkParameterIsNotNull(event, (String)"event");
            this.event = event;
            this.mainThread = mainThread;
            this.sync = sync;
            this.delay = delay;
        }

        public /* synthetic */ IMessage(Class clazz, boolean bl, boolean bl2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                l = 0L;
            }
            this(clazz, bl, bl2, l);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tH&\u00a8\u0006\n"}, d2={"Ltv/athena/core/sly/SlyBridge$IMessageHandler;", "", "handlerMessage", "", "message", "Landroid/os/Message;", "messages", "Ljava/util/ArrayList;", "Ltv/athena/core/sly/SlyBridge$IMessage;", "Lkotlin/collections/ArrayList;", "core_release"})
    public static interface IMessageHandler {
        @NotNull
        public ArrayList<IMessage> messages();

        public void handlerMessage(@NotNull Message var1);
    }
}

