package tv.athena.core.interceptor

import android.content.Intent

internal class ActivityResultInterceptorImpl: ActivityResultInterceptor {
    private val mActivityResultInterceptorList = mutableListOf<ActivityResultCallback>()

    override fun registerActivityResultInterceptor(callback: ActivityResultCallback) {
        if (!mActivityResultInterceptorList.contains(callback)) {
            mActivityResultInterceptorList.add(callback)
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?): Boolean {
        for (item in mActivityResultInterceptorList) {
            if (item.onActivityResult(requestCode, resultCode, data ?: Intent())) {
                return true
            }
        }
        return false
    }

    override fun onDestroy() {
        for (item in mActivityResultInterceptorList) {
            item.onDestroy()
        }
        mActivityResultInterceptorList.clear()
    }

}