package tv.athena.core.interceptor

import android.content.Intent

interface ActivityResultInterceptor {
    fun registerActivityResultInterceptor(callback: ActivityResultCallback)

    fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?): Boolean

    fun onDestroy()

    object Factory {
        @JvmStatic
        fun create(): ActivityResultInterceptor = ActivityResultInterceptorImpl()
    }
}