package tv.athena.core.axis

import android.util.Log
import java.util.concurrent.ConcurrentHashMap

/**
 * @author huangfan(kael)
 * @time 2018/5/16 17:45
 */

class AxisCenter {

    companion object {

        private const val TAG = "AxisCenter"

        /**
         * 存储实例的map
         */
        private val mCenter: ConcurrentHashMap<Class<*>, Any?> = ConcurrentHashMap()

        /**
         * 根据clazz获取实际的实例
         */
        fun <T> getAxisPoint(clazz: Class<T>) : T?{
            var axis = mCenter[clazz]
            if(axis == null){
                synchronized(clazz){
                    try{
                        axis = mCenter[clazz]
                        if(axis == null){
                            val clazzName = "${clazz.canonicalName}\$\$AxisBinder"
                            val axisProvider = Class.forName(clazzName).newInstance()
                            axis = (axisProvider as? AxisProvider<T>)?.buildAxisPoint(clazz)
                            (axis as? AxisLifecycle)?.init()
                            mCenter[clazz] = axis
                        }
                    }catch (e: Exception){
                        Log.e(TAG, "newInstance Axis Service fail, $e")
                        return null
                    }
                }
            }
            return axis as T
        }

        /**
         * 销毁serviceInterface对应的impl实例，并调用unInit(假如是AxisLifecycle)
         */
        fun <T> removeAxisPoint(clazz: Class<T>) {
            (mCenter.remove(clazz) as? AxisLifecycle)?.unInit()
        }
    }
}