package tv.athena.core.axis

/**
 * @author huangfan(kael)
 * @time 2018/5/16 16:59
 */
class Axis{

    companion object {

        /**
         * 根据serviceInterface获取实际的impl实例
         */
        fun <T> getService(serviceInterface: Class<T>) : T?{
            return AxisCenter.getAxisPoint(serviceInterface)
        }

        /**
         * 销毁serviceInterface对应的impl实例，并调用unInit(假如是AxisLifecycle)
         */
        fun <T> destroyService(serviceInterface: Class<T>){
            AxisCenter.removeAxisPoint(serviceInterface)
        }
    }
}