/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.util;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import se.bjurr.violations.lib.util.StringUtils;

public final class ViolationParserUtils {
    public static String asString(XMLStreamReader xmlr) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new StAXSource(xmlr), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public static Optional<String> findAttribute(String in, String attribute) {
        Pattern pattern = Pattern.compile(attribute + "='([^']+?)'");
        Matcher matcher = pattern.matcher(in);
        if (matcher.find()) {
            return Optional.ofNullable(StringUtils.xmlDecode(matcher.group(1)));
        }
        pattern = Pattern.compile(attribute + "=\"([^\"]+?)\"");
        matcher = pattern.matcher(in);
        if (matcher.find()) {
            return Optional.ofNullable(StringUtils.xmlDecode(matcher.group(1)));
        }
        return Optional.empty();
    }

    public static Optional<String> findAttribute(XMLStreamReader in, String attribute) {
        return Optional.ofNullable(in.getAttributeValue("", attribute));
    }

    public static Optional<Integer> findIntegerAttribute(String in, String attribute) {
        if (ViolationParserUtils.findAttribute(in, attribute).isPresent()) {
            return Optional.ofNullable(Integer.parseInt(ViolationParserUtils.getAttribute(in, attribute)));
        }
        return Optional.empty();
    }

    public static Optional<Integer> findIntegerAttribute(XMLStreamReader in, String attribute) {
        String attr = in.getAttributeValue("", attribute);
        if (attr == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(Integer.parseInt(attr));
    }

    public static String getAttribute(String in, String attribute) {
        Optional<String> foundOpt = ViolationParserUtils.findAttribute(in, attribute);
        if (foundOpt.isPresent()) {
            return foundOpt.get();
        }
        throw new RuntimeException("\"" + attribute + "\" not found in \"" + in + "\"");
    }

    public static String getAttribute(XMLStreamReader in, String attribute) {
        String foundOpt = in.getAttributeValue("", attribute);
        if (foundOpt == null) {
            String foundin;
            try {
                foundin = ViolationParserUtils.asString(in);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException("\"" + attribute + "\" not found in:\n" + foundin);
        }
        return foundOpt;
    }

    public static List<String> getChunks(String in, String includingStart, String includingEnd) {
        Pattern pattern = Pattern.compile("(" + includingStart + ".+?" + includingEnd + ")", 32);
        Matcher matcher = pattern.matcher(in);
        ArrayList<String> chunks = new ArrayList<String>();
        while (matcher.find()) {
            chunks.add(matcher.group());
        }
        return chunks;
    }

    public static String getContent(String in, String tag) {
        Pattern pattern = Pattern.compile("<" + tag + "\\s?[^>]*>[^<]*<!\\[CDATA\\[(.+?)\\]\\]>[^<]*</" + tag + ">", 32);
        Matcher matcher = pattern.matcher(in);
        if (matcher.find()) {
            return matcher.group(1);
        }
        pattern = Pattern.compile("<" + tag + "\\s?[^>]*>(.+?)</" + tag + ">", 32);
        matcher = pattern.matcher(in);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new RuntimeException("\"" + tag + "\" not found in " + in);
    }

    public static Integer getIntegerAttribute(String in, String attribute) {
        return Integer.parseInt(ViolationParserUtils.getAttribute(in, attribute));
    }

    public static Integer getIntegerAttribute(XMLStreamReader in, String attribute) {
        return Integer.parseInt(ViolationParserUtils.getAttribute(in, attribute));
    }

    public static Integer getIntegerContent(String in, String tag) {
        String content = ViolationParserUtils.getContent(in, tag);
        return Integer.parseInt(content);
    }

    public static List<String> getLines(String string) {
        return Arrays.asList(string.split("\n"));
    }

    public static List<List<String>> getLines(String string, String regexpPerLine) {
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        Pattern pattern = Pattern.compile(regexpPerLine);
        for (String line : string.split("\n")) {
            List<String> found = ViolationParserUtils.getLineParts(pattern, line);
            if (found == null) continue;
            results.add(found);
        }
        return results;
    }

    public static List<String> getLineParts(Pattern pattern, String line) {
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        ArrayList<String> lineParts = new ArrayList<String>();
        for (int g = 0; g <= matcher.groupCount(); ++g) {
            lineParts.add(matcher.group(g));
        }
        return lineParts;
    }

    public static List<String> getParts(String string, String ... regexpList) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String regexp : regexpList) {
            Pattern pattern = Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(string);
            boolean found = matcher.find();
            if (!found) {
                return new ArrayList<String>();
            }
            String part = matcher.group(1).trim();
            parts.add(part);
            string = string.replaceFirst(Pattern.quote(matcher.group()), "").trim();
        }
        return parts;
    }

    private ViolationParserUtils() {
    }
}

