/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.violationslib.com.google.gson.Gson;

public class SonarParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        SonarReport sonarReport = new Gson().fromJson(string, SonarReport.class);
        ArrayList<Violation> violations = new ArrayList<Violation>();
        for (SonarReportIssue issue : sonarReport.getIssues()) {
            violations.add(Violation.violationBuilder().setFile(issue.getFile()).setCategory(issue.getCategory()).setEndLine(issue.endLine).setMessage(issue.message).setParser(Parser.SONAR).setReporter(Parser.SONAR.name()).setRule(issue.rule).setSeverity(issue.getSeverity()).setStartLine(issue.startLine).setSource(issue.component).build());
        }
        return violations;
    }

    static class SonarReport {
        String version;
        private List<SonarReportIssue> issues;

        SonarReport() {
        }

        public void setIssues(List<SonarReportIssue> issues) {
            this.issues = issues;
        }

        public List<SonarReportIssue> getIssues() {
            if (this.issues == null) {
                return new ArrayList<SonarReportIssue>();
            }
            return this.issues;
        }
    }

    static class SonarReportIssue {
        String component;
        int line;
        int startLine;
        int endLine;
        String message;
        String severity;
        String rule;

        SonarReportIssue() {
        }

        public String getFile() {
            try {
                String[] parts = this.component.split(":");
                return parts[parts.length - 1];
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot understand file " + this.component);
            }
        }

        public String getCategory() {
            try {
                return this.rule.split(":")[0];
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot understand category " + this.rule);
            }
        }

        public SEVERITY getSeverity() {
            if (this.severity.equalsIgnoreCase("blocker")) {
                return SEVERITY.ERROR;
            }
            if (this.severity.equalsIgnoreCase("critical") || this.severity.equalsIgnoreCase("major")) {
                return SEVERITY.WARN;
            }
            return SEVERITY.INFO;
        }
    }
}

