/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class SimianParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes("UTF-8"));){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlr = factory.createXMLStreamReader(input);
            String sourceFile = null;
            Integer lineCount = null;
            Integer startLineNumber = null;
            Integer endLineNumber = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("set")) {
                    lineCount = ViolationParserUtils.getIntegerAttribute(xmlr, "lineCount");
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("block")) continue;
                sourceFile = ViolationParserUtils.getAttribute(xmlr, "sourceFile");
                startLineNumber = ViolationParserUtils.getIntegerAttribute(xmlr, "startLineNumber");
                endLineNumber = ViolationParserUtils.getIntegerAttribute(xmlr, "endLineNumber");
                Violation violation = Violation.violationBuilder().setParser(Parser.SIMIAN).setFile(sourceFile).setMessage("Duplication").setRule("DUPLICATION").setSeverity(this.toSeverity(lineCount)).setStartLine(startLineNumber).setEndLine(endLineNumber).build();
                violations.add(violation);
            }
        }
        return violations;
    }

    private SEVERITY toSeverity(Integer lineCount) {
        if (lineCount < 10) {
            return SEVERITY.INFO;
        }
        if (lineCount < 50) {
            return SEVERITY.WARN;
        }
        return SEVERITY.ERROR;
    }
}

