/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class ResharperParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<String> issueTypeChunks = ViolationParserUtils.getChunks(string, "<IssueType ", "/>");
        HashMap issueTypesPerTypeId = new HashMap();
        for (String issueTypesChunk : issueTypeChunks) {
            HashMap<String, String> issueType = new HashMap<String, String>();
            String id = ViolationParserUtils.getAttribute(issueTypesChunk, "Id");
            issueType.put("category", ViolationParserUtils.getAttribute(issueTypesChunk, "Category"));
            Optional<String> description = ViolationParserUtils.findAttribute(issueTypesChunk, "Description");
            issueType.put("description", description.orElse(id));
            issueType.put("severity", ViolationParserUtils.getAttribute(issueTypesChunk, "Severity"));
            issueType.put("url", ViolationParserUtils.findAttribute(issueTypesChunk, "WikiUrl").orElse(null));
            issueTypesPerTypeId.put(id, issueType);
        }
        List<String> issueChunks = ViolationParserUtils.getChunks(string, "<Issue ", "/>");
        for (String issueChunk : issueChunks) {
            String typeId = ViolationParserUtils.getAttribute(issueChunk, "TypeId");
            String filename = ViolationParserUtils.getAttribute(issueChunk, "File");
            String url = (String)((Map)issueTypesPerTypeId.get(typeId)).get("url");
            String message = ViolationParserUtils.getAttribute(issueChunk, "Message") + ". " + (String)((Map)issueTypesPerTypeId.get(typeId)).get("category") + ". " + (String)((Map)issueTypesPerTypeId.get(typeId)).get("description") + (url != null ? ". For more info, visit " + url : "");
            Integer line = ViolationParserUtils.findIntegerAttribute(issueChunk, "Line").orElse(0);
            String severity = (String)((Map)issueTypesPerTypeId.get(typeId)).get("severity");
            violations.add(Violation.violationBuilder().setParser(Parser.RESHARPER).setStartLine(line).setFile(filename).setSeverity(this.toSeverity(severity)).setMessage(message).setRule(typeId).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("ERROR")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("WARNING")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

