/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class PyDocStyleParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        boolean fileLine = true;
        List<String> lines = ViolationParserUtils.getLines(string);
        String filename = null;
        Integer line = null;
        for (String inputLine : lines) {
            List<String> parts;
            if (fileLine) {
                parts = ViolationParserUtils.getParts(inputLine, "([^:]*)", "(\\d+)");
                filename = parts.get(0);
                line = Integer.parseInt(parts.get(1));
            } else {
                parts = ViolationParserUtils.getParts(inputLine, "([^:]*)", ":(.*)");
                String rule = parts.get(0);
                String message = parts.get(1);
                violations.add(Violation.violationBuilder().setParser(Parser.PYDOCSTYLE).setStartLine(line).setFile(filename).setRule(rule).setSeverity(SEVERITY.ERROR).setMessage(message).build());
            }
            fileLine = !fileLine;
        }
        return violations;
    }
}

