/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class PiTestParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        String mutations = ViolationParserUtils.getContent(string, "mutations");
        List<String> mutationChunks = ViolationParserUtils.getChunks(mutations, "<mutation", "</mutation>");
        for (String mutationChunk : mutationChunks) {
            String mutatedClass = ViolationParserUtils.getContent(mutationChunk, "mutatedClass");
            String sourceFile = ViolationParserUtils.getContent(mutationChunk, "sourceFile");
            String filename = this.toFilename(mutatedClass, sourceFile);
            String status = ViolationParserUtils.getAttribute(mutationChunk, "status");
            String detected = ViolationParserUtils.getAttribute(mutationChunk, "detected");
            String mutatedMethod = ViolationParserUtils.getContent(mutationChunk, "mutatedMethod");
            String methodDescription = ViolationParserUtils.getContent(mutationChunk, "methodDescription");
            String mutator = ViolationParserUtils.getContent(mutationChunk, "mutator");
            String message = status + ", " + mutator + ", " + methodDescription;
            Integer startLine = ViolationParserUtils.getIntegerContent(mutationChunk, "lineNumber");
            Integer index = ViolationParserUtils.getIntegerContent(mutationChunk, "index");
            HashMap<String, String> specifics = new HashMap<String, String>();
            specifics.put("detected", detected);
            specifics.put("mutatedMethod", mutatedMethod);
            specifics.put("mutatedClass", mutatedClass);
            specifics.put("status", status);
            specifics.put("methodDescription", methodDescription);
            violations.add(Violation.violationBuilder().setRule(mutator).setSource(sourceFile).setParser(Parser.PITEST).setStartLine(startLine).setColumn(index).setFile(filename).setSeverity(SEVERITY.WARN).setMessage(message).setSpecifics(specifics).build());
        }
        return violations;
    }

    private String toFilename(String mutatedClass, String sourceFile) {
        return mutatedClass.substring(0, mutatedClass.lastIndexOf(".")).replaceAll("\\.", "/") + "/" + sourceFile;
    }
}

