/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class KotlinGradleParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(string, "(w|e):([^:]*)[^\\d]+?(\\d+?)[^\\d]+?(\\d+?)[^:]+?:(.*)");
        for (List<String> parts : partsPerLine) {
            String severity = parts.get(1).trim();
            String filename = parts.get(2).trim();
            Integer line = Integer.parseInt(parts.get(3));
            Integer column = Integer.parseInt(parts.get(4));
            String message = parts.get(5).trim();
            violations.add(Violation.violationBuilder().setParser(Parser.KOTLINGRADLE).setStartLine(line).setColumn(column).setFile(filename).setSeverity(this.toSeverity(severity)).setMessage(message).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("e")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("w")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

