/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class JUnitParser
implements ViolationsParser {
    private static Logger LOG = Logger.getLogger(JUnitParser.class.getSimpleName());

    @Override
    public List<Violation> parseReportOutput(String reportContent) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<String> errors = ViolationParserUtils.getChunks(reportContent, "<testcase", "(/>|</testcase>)");
        for (String errorChunk : errors) {
            List<String> failureChunks = ViolationParserUtils.getChunks(errorChunk, "<failure", "</failure>");
            List<String> errorChunks = ViolationParserUtils.getChunks(errorChunk, "<error", "</error>");
            ArrayList<String> chunks = new ArrayList<String>();
            chunks.addAll(failureChunks);
            chunks.addAll(errorChunks);
            for (String failure : chunks) {
                int lineOfFailure;
                String message = ViolationParserUtils.getAttribute(failure, "message");
                String className = ViolationParserUtils.getAttribute(errorChunk, "classname");
                String name = ViolationParserUtils.getAttribute(errorChunk, "name");
                String type = ViolationParserUtils.getAttribute(errorChunk, "type");
                List<String> failLine = ViolationParserUtils.getChunks(failure, className + "." + name, "\\)");
                if (failLine.isEmpty()) {
                    LOG.log(Level.WARNING, "Found failure, but failed to find fail line from stacktrace");
                    continue;
                }
                List<String> fileNameAndLine = ViolationParserUtils.getChunks(failLine.get(0), "\\(", "\\)");
                if (fileNameAndLine.isEmpty()) {
                    LOG.log(Level.WARNING, "Found failure line from stacktrace. But failed to get File name and line number from it.");
                    continue;
                }
                String[] split = fileNameAndLine.get(0).split("[.\\:\\)]");
                if (split.length < 3) {
                    LOG.log(Level.WARNING, "Failed to split Filename to its ending and line number");
                    continue;
                }
                try {
                    lineOfFailure = Integer.parseInt(split[2]);
                }
                catch (NumberFormatException e) {
                    LOG.log(Level.WARNING, "Failed to parse line number from: " + split[2]);
                    continue;
                }
                violations.add(Violation.violationBuilder().setParser(Parser.JUNIT).setMessage(name + " : " + message).setStartLine(lineOfFailure).setFile(className.replaceAll("\\.", "/") + "." + split[1]).setSource(className).setRule(type).setSeverity(SEVERITY.ERROR).build());
            }
        }
        return violations;
    }
}

