/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class JSLintParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<String> files = ViolationParserUtils.getChunks(string, "<file", "</file>");
        for (String fileChunk : files) {
            String filename = ViolationParserUtils.getAttribute(fileChunk, "name");
            List<String> issues = ViolationParserUtils.getChunks(fileChunk, "<issue", "/>");
            for (String issueChunk : issues) {
                Integer line = ViolationParserUtils.getIntegerAttribute(issueChunk, "line");
                Integer charAttrib = ViolationParserUtils.getIntegerAttribute(issueChunk, "char");
                String severity = ViolationParserUtils.getAttribute(issueChunk, "severity");
                String reason = ViolationParserUtils.getAttribute(issueChunk, "reason").trim();
                String evidence = ViolationParserUtils.getAttribute(issueChunk, "evidence").trim();
                String message = reason + ": " + evidence;
                violations.add(Violation.violationBuilder().setParser(Parser.JSLINT).setStartLine(line).setColumn(charAttrib).setFile(filename).setSeverity(this.toSeverity(severity)).setMessage(message).build());
            }
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("E")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("W")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

